/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.misc.PsiElementSetSpinAllocator;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntMacroDef;
import com.intellij.lang.ant.psi.AntPresetDef;
import com.intellij.lang.ant.psi.AntScriptDef;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.AntTask;
import com.intellij.lang.ant.psi.impl.reference.AntElementCompletionWrapper;
import com.intellij.lang.ant.psi.impl.reference.AntGenericReference;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntElementNameReference
extends AntGenericReference {
    public AntElementNameReference(AntStructuredElement element) {
        super(element);
    }

    public AntElementNameReference(AntStructuredElement element, XmlAttribute attr) {
        super(element, attr);
    }

    @Override
    public AntStructuredElement getElement() {
        return (AntStructuredElement)super.getElement();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        AntStructuredElement element = this.getElement();
        AntTypeDefinition typeDef = element.getTypeDefinition();
        if (typeDef == null) {
            return element;
        }
        if (!(element instanceof AntTask)) {
            AntStructuredElement defElement = (AntStructuredElement)typeDef.getDefiningElement();
            if (defElement != null && (defElement instanceof AntPresetDef || (defElement.getParent() instanceof AntMacroDef || defElement.getParent() instanceof AntScriptDef) && "element".equals(defElement.getSourceElement().getName()))) {
                element.getSourceElement().setName(newElementName);
            }
        } else {
            AntTask task = (AntTask)element;
            if (task.isMacroDefined() || task.isScriptDefined() || task.isPresetDefined() || task.isTypeDefined()) {
                XmlAttribute attr = this.getAttribute();
                if (attr == null) {
                    task.getSourceElement().setName(newElementName);
                } else {
                    attr.setName(newElementName);
                }
            }
        }
        return element;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/AntElementNameReference.bindToElement must not be null");
        }
        if (element instanceof AntStructuredElement) {
            return this.handleElementRename(((AntStructuredElement)element).getName());
        }
        return this.getElement();
    }

    @Override
    public PsiElement resolveInner() {
        AntStructuredElement element = this.getElement();
        AntTypeDefinition elementDef = element.getTypeDefinition();
        if (elementDef != null) {
            PsiElement definingElement = elementDef.getDefiningElement();
            if (element.isPresetDefined() || element.isTypeDefined()) {
                return definingElement;
            }
            if (!(element instanceof AntTask)) {
                return definingElement == null ? AntElementNameReference.findClass(elementDef, element) : definingElement;
            }
            AntTask task = (AntTask)element;
            if (task.isMacroDefined() || task.isScriptDefined()) {
                XmlAttribute attr = this.getAttribute();
                if (definingElement != null && attr != null) {
                    String attribName = attr.getName();
                    for (PsiElement child : definingElement.getChildren()) {
                        if (!(child instanceof AntStructuredElement) || !attribName.equals(((AntStructuredElement)child).getName())) continue;
                        return child;
                    }
                }
                return definingElement;
            }
            return AntElementNameReference.findClass(elementDef, element);
        }
        return null;
    }

    @Override
    public boolean shouldBeSkippedByAnnotator() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        if (this.getAttribute() != null) {
            objectArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntElementNameReference.getVariants must not return null");
            return objectArray;
        }
        final AntStructuredElement parent = (AntStructuredElement)this.getElement().getAntParent();
        if (parent == null) {
            objectArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntElementNameReference.getVariants must not return null");
            return objectArray;
        }
        AntTypeDefinition def = parent.getTypeDefinition();
        if (def == null && (def = parent.getAntProject().getTypeDefinition()) == null) {
            objectArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntElementNameReference.getVariants must not return null");
            return objectArray;
        }
        AntFile antFile = parent.getAntFile();
        final Project project = antFile.getProject();
        final Set<PsiElement> ids = PsiElementSetSpinAllocator.alloc();
        for (AntTypeId id : def.getNestedElements()) {
            ids.add(new AntElementCompletionWrapper(parent, id.getName() + " ", project, AntElementRole.TASK_ROLE));
        }
        if (def.isAllTaskContainer()) {
            new Object(){
                final Set<AntFile> processedFiles = new HashSet<AntFile>();
                final Set<AntTypeId> processedTypes = new HashSet<AntTypeId>();

                void walkFiles(AntFile file) {
                    if (this.processedFiles.contains(file)) {
                        return;
                    }
                    this.processedFiles.add(file);
                    for (AntTypeDefinition _def : file.getBaseTypeDefinitions()) {
                        AntTypeId typeId;
                        if (!_def.isTask() || this.processedTypes.contains(typeId = _def.getTypeId())) continue;
                        this.processedTypes.add(typeId);
                        ids.add(new AntElementCompletionWrapper(parent, typeId.getName() + " ", project, AntElementRole.TASK_ROLE));
                    }
                    for (AntFile imported : file.getAntProject().getImportedFiles()) {
                        this.walkFiles(imported);
                    }
                }
            }.walkFiles(antFile);
        }
        Object[] objectArray2 = ArrayUtil.toObjectArray(ids);
        objectArray = objectArray2;
        if (objectArray2 != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntElementNameReference.getVariants must not return null");
        finally {
            PsiElementSetSpinAllocator.dispose(ids);
        }
    }

    @Nullable
    private static PsiElement findClass(AntTypeDefinition elementDef, AntStructuredElement element) {
        String clazz = elementDef.getClassName();
        return JavaPsiFacade.getInstance((Project)element.getProject()).findClass(clazz, GlobalSearchScope.allScope((Project)element.getProject()));
    }
}

