/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.actions.PreviewFormAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;

public final class CopyResourcesUtil {
    private CopyResourcesUtil() {
    }

    public static File copyClass(String targetPath, @NonNls String className, boolean deleteOnExit) throws IOException {
        String resourceName;
        InputStream stream;
        File targetDir = new File(targetPath).getAbsoluteFile();
        File file = new File(targetDir, className + ".class");
        FileUtil.createParentDirs((File)file);
        if (deleteOnExit) {
            for (File f = file; f != null && !f.equals(targetDir); f = f.getParentFile()) {
                f.deleteOnExit();
            }
        }
        if ((stream = PreviewFormAction.class.getResourceAsStream(resourceName = "/" + className + ".class")) == null) {
            throw new IOException("cannot load " + resourceName);
        }
        return CopyResourcesUtil.copyStreamToFile(stream, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyStreamToFile(InputStream stream, File file) throws IOException {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                FileUtil.copy((InputStream)stream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            stream.close();
        }
        return file;
    }

    public static void copyProperties(String targetPath, String fileName) throws IOException {
        File targetDir = new File(targetPath).getAbsoluteFile();
        File file = new File(targetDir, fileName);
        FileUtil.createParentDirs((File)file);
        for (File f = file; f != null && !f.equals(targetDir); f = f.getParentFile()) {
            f.deleteOnExit();
        }
        String resourceName = "/" + fileName;
        InputStream stream = PreviewFormAction.class.getResourceAsStream(resourceName);
        if (stream == null) {
            return;
        }
        CopyResourcesUtil.copyStreamToFile(stream, file);
    }

    public static void copyFormsRuntime(String targetDir, boolean deleteOnExit) throws IOException {
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/AbstractLayout", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/DimensionInfo", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/GridConstraints", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/GridLayoutManager", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/HorizontalInfo", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/LayoutState", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/Spacer", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/SupportCode$TextWithMnemonic", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/SupportCode", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/Util", deleteOnExit);
        CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/VerticalInfo", deleteOnExit);
    }
}

