/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CouplingVisitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ClassCouplingInspection
extends ClassMetricInspection {
    private static final int DEFAULT_COUPLING_LIMIT = 15;
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @NotNull
    public String getID() {
        if ("OverlyCoupledClass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ClassCouplingInspection.getID must not return null");
        }
        return "OverlyCoupledClass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.coupled.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ClassCouplingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer totalDependencies = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.coupled.class.problem.descriptor", totalDependencies);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ClassCouplingInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 15;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("overly.coupled.class.class.coupling.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        String configurationLabel = this.getConfigurationLabel();
        JLabel label = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)valueField, constraints);
        JCheckBox arrayCheckBox = new JCheckBox(InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), this.m_includeJavaClasses);
        final ButtonModel arrayModel = arrayCheckBox.getModel();
        arrayModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClassCouplingInspection.this.m_includeJavaClasses = arrayModel.isSelected();
            }
        });
        JCheckBox objectCheckBox = new JCheckBox(InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), this.m_includeLibraryClasses);
        final ButtonModel model = objectCheckBox.getModel();
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClassCouplingInspection.this.m_includeLibraryClasses = model.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)arrayCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        panel.add((Component)objectCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassCouplingVisitor();
    }

    private class ClassCouplingVisitor
    extends BaseInspectionVisitor {
        private ClassCouplingVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ClassCouplingInspection$ClassCouplingVisitor.visitClass must not be null");
            }
            int totalDependencies = this.calculateTotalDependencies(aClass);
            if (totalDependencies <= ClassCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalDependencies);
        }

        private int calculateTotalDependencies(PsiClass aClass) {
            CouplingVisitor visitor = new CouplingVisitor(aClass, ClassCouplingInspection.this.m_includeJavaClasses, ClassCouplingInspection.this.m_includeLibraryClasses);
            aClass.accept((PsiElementVisitor)visitor);
            return visitor.getNumDependencies();
        }
    }
}

