/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ReplaceInheritanceWithDelegationFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ExtendsConcreteCollectionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassExtendsConcreteCollection" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspection.getID must not return null");
        }
        return "ClassExtendsConcreteCollection";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        if (superClass instanceof PsiAnonymousClass) {
            return null;
        }
        return new ReplaceInheritanceWithDelegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsConcreteCollectionVisitor();
    }

    private static class ExtendsConcreteCollectionVisitor
    extends BaseInspectionVisitor {
        private ExtendsConcreteCollectionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspection$ExtendsConcreteCollectionVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (!CollectionUtils.isCollectionClass(superClass)) {
                return;
            }
            this.registerClassError(aClass, superClass);
        }
    }
}

