/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class InnerClassReferenceVisitor
extends JavaRecursiveElementVisitor {
    private final PsiClass innerClass;
    private boolean referencesStaticallyAccessible = true;

    public InnerClassReferenceVisitor(PsiClass innerClass) {
        this.innerClass = innerClass;
    }

    public boolean canInnerClassBeStatic() {
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(PsiClass aClass) {
        if (aClass.hasModifierProperty("static") && !PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)this.innerClass, (boolean)false)) {
            return true;
        }
        if (InheritanceUtil.isCorrectDescendant((PsiClass)this.innerClass, (PsiClass)aClass, (boolean)true)) {
            return true;
        }
        PsiClass classScope = aClass;
        PsiClass outerClass = ClassUtils.getContainingClass((PsiElement)this.innerClass);
        while (classScope != null) {
            if (InheritanceUtil.isCorrectDescendant((PsiClass)outerClass, (PsiClass)classScope, (boolean)true)) {
                return false;
            }
            PsiElement scope = classScope.getScope();
            if (scope instanceof PsiClass) {
                classScope = (PsiClass)scope;
                continue;
            }
            classScope = null;
        }
        return true;
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/InnerClassReferenceVisitor.visitThisExpression must not be null");
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression);
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        if (this.isContainingClassQualifier(qualifier)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/InnerClassReferenceVisitor.visitSuperExpression must not be null");
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression);
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        if (this.isContainingClassQualifier(qualifier)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean isContainingClassQualifier(PsiJavaCodeReferenceElement qualifier) {
        if (qualifier == null) {
            return false;
        }
        PsiElement element = qualifier.resolve();
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return !aClass.equals(this.innerClass);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/InnerClassReferenceVisitor.visitReferenceElement must not be null");
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        PsiElement parent = reference.getParent();
        if (parent instanceof PsiThisExpression || parent instanceof PsiSuperExpression) {
            return;
        }
        super.visitReferenceElement(reference);
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        PsiElement scope = aClass.getScope();
        if (!(scope instanceof PsiClass)) {
            return;
        }
        this.referencesStaticallyAccessible &= aClass.hasModifierProperty("static");
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        PsiReferenceExpression referenceExpression;
        PsiElement resolvedExpression;
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/InnerClassReferenceVisitor.visitReferenceExpression must not be null");
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitReferenceExpression(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier instanceof PsiSuperExpression) {
            return;
        }
        if (qualifier instanceof PsiReferenceExpression && !((resolvedExpression = (referenceExpression = (PsiReferenceExpression)qualifier).resolve()) instanceof PsiField) && !(resolvedExpression instanceof PsiMethod)) {
            return;
        }
        PsiElement element = expression.resolve();
        if (element instanceof PsiMethod || element instanceof PsiField) {
            PsiMember member = (PsiMember)element;
            if (member.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = member.getContainingClass();
            this.referencesStaticallyAccessible &= this.isClassStaticallyAccessible(containingClass);
        }
        if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
            PsiElement containingMethod = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            PsiElement referencedMethod = PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (containingMethod != null && referencedMethod != null && !containingMethod.equals(referencedMethod)) {
                this.referencesStaticallyAccessible = false;
            }
        }
    }
}

