/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nullable;

class ConstantSubexpressionPredicate
implements PsiElementPredicate {
    ConstantSubexpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken) && !(element.getPrevSibling() instanceof PsiJavaToken)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
        PsiType type = binaryExpression.getType();
        if (type == null || type.equalsToText("java.lang.String")) {
            return false;
        }
        PsiBinaryExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(binaryExpression);
        if (subexpression == null) {
            return false;
        }
        if (binaryExpression.equals(subexpression) && !ConstantSubexpressionPredicate.isPartOfConstantExpression(binaryExpression)) {
            return false;
        }
        if (!PsiUtil.isConstantExpression((PsiExpression)subexpression)) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression((PsiExpression)subexpression);
        return value != null;
    }

    private static boolean isPartOfConstantExpression(PsiBinaryExpression binaryExpression) {
        PsiElement containingElement = binaryExpression.getParent();
        if (containingElement instanceof PsiExpression) {
            PsiExpression containingExpression = (PsiExpression)containingElement;
            return PsiUtil.isConstantExpression((PsiExpression)containingExpression);
        }
        return false;
    }

    @Nullable
    private static PsiBinaryExpression getSubexpression(PsiBinaryExpression expression) {
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return null;
        }
        PsiExpression lhs = expression.getLOperand();
        if (!(lhs instanceof PsiBinaryExpression)) {
            return expression;
        }
        PsiBinaryExpression lhsBinaryExpression = (PsiBinaryExpression)lhs;
        PsiExpression leftSide = lhsBinaryExpression.getROperand();
        if (leftSide == null) {
            return null;
        }
        try {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression.copy();
            PsiExpression lOperand = binaryExpression.getLOperand();
            lOperand.replace((PsiElement)leftSide);
            return binaryExpression;
        }
        catch (Throwable ignore) {
            return null;
        }
    }
}

