/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.PsiSelectionSearcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipSetterCallIntention
extends Intention {
    private static final PsiElementPredicate PREDICATE = new SetterCallPredicate();

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/expression/FlipSetterCallIntention.processIntention must not be null");
        }
        Editor editor = FlipSetterCallIntention.getEditorByElementIfItHasSelection(element);
        if (editor == null) {
            if (element instanceof PsiMethodCallExpression) {
                FlipSetterCallIntention.flipCall((PsiMethodCallExpression)element);
            }
        } else {
            List<PsiMethodCallExpression> methodCalls = PsiSelectionSearcher.searchElementsInSelection(editor, element.getProject(), PsiMethodCallExpression.class, false);
            for (PsiMethodCallExpression call : methodCalls) {
                FlipSetterCallIntention.flipCall(call);
            }
            editor.getSelectionModel().removeSelection();
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = PREDICATE;
        if (psiElementPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/expression/FlipSetterCallIntention.getElementPredicate must not return null");
        }
        return psiElementPredicate;
    }

    private static void flipCall(PsiMethodCallExpression call) {
        PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
        if (qualifierExpression == null) {
            return;
        }
        String qualifier1 = qualifierExpression.getText();
        if (qualifier1 == null || qualifier1.length() == 0) {
            return;
        }
        PsiMethodCallExpression param = (PsiMethodCallExpression)call.getArgumentList().getExpressions()[0];
        qualifierExpression = param.getMethodExpression().getQualifierExpression();
        if (qualifierExpression == null) {
            return;
        }
        String qualifier2 = qualifierExpression.getText();
        PsiMethod setter = call.resolveMethod();
        PsiMethod getter = param.resolveMethod();
        if (getter == null || setter == null) {
            return;
        }
        PsiMethod get = PropertyUtil.findPropertyGetter((PsiClass)setter.getContainingClass(), (String)PropertyUtil.getPropertyName((PsiMethod)setter), (boolean)false, (boolean)true);
        PsiMethod set = PropertyUtil.findPropertySetter((PsiClass)getter.getContainingClass(), (String)PropertyUtil.getPropertyName((PsiMethod)getter), (boolean)false, (boolean)true);
        if (get == null || set == null) {
            return;
        }
        StringBuilder text = new StringBuilder();
        text.append(qualifier2).append(".").append(set.getName()).append("(").append(qualifier1).append(".").append(get.getName()).append("()").append(")");
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)call.getProject()).createExpressionFromText(text.toString(), call.getContext());
        call.replace((PsiElement)newExpression);
    }

    private static boolean isSetGetMethodCall(PsiMethodCallExpression call) {
        PsiExpression[] params = call.getArgumentList().getExpressions();
        if (params.length != 1) {
            return false;
        }
        if (!(params[0] instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call2 = (PsiMethodCallExpression)params[0];
        PsiElement methodElement = call.getMethodExpression().resolve();
        PsiElement param = call2.getMethodExpression().resolve();
        if (!(methodElement instanceof PsiMethod && param instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)methodElement)) && PropertyUtil.isSimplePropertyGetter((PsiMethod)((PsiMethod)param)))) {
            return false;
        }
        PsiMethod setter1 = (PsiMethod)methodElement;
        PsiMethod getter2 = (PsiMethod)param;
        if (!call.getArgumentList().getExpressionTypes()[0].equals(getter2.getReturnType())) {
            return false;
        }
        PsiMethod getter1 = PropertyUtil.findPropertyGetter((PsiClass)setter1.getContainingClass(), (String)PropertyUtil.getPropertyName((PsiMethod)setter1), (boolean)false, (boolean)true);
        if (getter1 == null) {
            return false;
        }
        PsiMethod setter2 = PropertyUtil.findPropertyGetter((PsiClass)getter2.getContainingClass(), (String)PropertyUtil.getPropertyName((PsiMethod)getter2), (boolean)false, (boolean)true);
        return setter2 != null;
    }

    @Nullable
    private static Editor getEditorByElementIfItHasSelection(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/expression/FlipSetterCallIntention.getEditorByElementIfItHasSelection must not be null");
        }
        Editor editor = FileEditorManager.getInstance((Project)element.getProject()).getSelectedTextEditor();
        return editor != null && editor.getSelectionModel().hasSelection() ? editor : null;
    }

    private static class SetterCallPredicate
    implements PsiElementPredicate {
        private SetterCallPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            boolean underCorrectElement = element instanceof PsiMethodCallExpression && FlipSetterCallIntention.isSetGetMethodCall((PsiMethodCallExpression)element);
            Editor editor = FileEditorManager.getInstance((Project)element.getProject()).getSelectedTextEditor();
            if (editor == null || !editor.getSelectionModel().hasSelection()) {
                return underCorrectElement;
            }
            List<PsiMethodCallExpression> list = PsiSelectionSearcher.searchElementsInSelection(editor, element.getProject(), PsiMethodCallExpression.class, false);
            for (PsiMethodCallExpression methodCallExpression : list) {
                if (!FlipSetterCallIntention.isSetGetMethodCall(methodCallExpression)) continue;
                return true;
            }
            return underCorrectElement;
        }
    }
}

