/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.interfacetoclass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.interfacetoclass.ConvertInterfaceToClassPredicate;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertInterfaceToClassIntention
extends Intention {
    private static void changeInterfaceToClass(PsiClass anInterface) throws IncorrectOperationException {
        PsiField[] fields;
        PsiMethod[] methods;
        PsiIdentifier nameIdentifier = anInterface.getNameIdentifier();
        assert (nameIdentifier != null);
        PsiElement whiteSpace = nameIdentifier.getPrevSibling();
        assert (whiteSpace != null);
        PsiElement interfaceToken = whiteSpace.getPrevSibling();
        assert (interfaceToken != null);
        PsiKeyword interfaceKeyword = (PsiKeyword)interfaceToken.getOriginalElement();
        Project project = anInterface.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiKeyword classKeyword = factory.createKeyword("class");
        interfaceKeyword.replace((PsiElement)classKeyword);
        PsiModifierList classModifierList = anInterface.getModifierList();
        if (classModifierList == null) {
            return;
        }
        classModifierList.setModifierProperty("abstract", true);
        PsiElement parent = anInterface.getParent();
        if (parent instanceof PsiClass) {
            classModifierList.setModifierProperty("static", true);
        }
        for (PsiMethod method : methods = anInterface.getMethods()) {
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("public", true);
            modifierList.setModifierProperty("abstract", true);
        }
        for (PsiField field : fields = anInterface.getFields()) {
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) continue;
            modifierList.setModifierProperty("public", true);
            modifierList.setModifierProperty("static", true);
            modifierList.setModifierProperty("final", true);
        }
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/interfacetoclass/ConvertInterfaceToClassIntention.processIntention must not be null");
        }
        PsiClass anInterface = (PsiClass)element.getParent();
        boolean success = ConvertInterfaceToClassIntention.moveSubClassImplementsToExtends(anInterface);
        if (!success) {
            return;
        }
        ConvertInterfaceToClassIntention.changeInterfaceToClass(anInterface);
        ConvertInterfaceToClassIntention.moveExtendsToImplements(anInterface);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertInterfaceToClassPredicate convertInterfaceToClassPredicate = new ConvertInterfaceToClassPredicate();
        if (convertInterfaceToClassPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/interfacetoclass/ConvertInterfaceToClassIntention.getElementPredicate must not return null");
        }
        return convertInterfaceToClassPredicate;
    }

    private static void moveExtendsToImplements(PsiClass anInterface) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] referenceElements;
        PsiReferenceList extendsList = anInterface.getExtendsList();
        PsiReferenceList implementsList = anInterface.getImplementsList();
        assert (extendsList != null);
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
            assert (implementsList != null);
            implementsList.add((PsiElement)referenceElement);
            referenceElement.delete();
        }
    }

    private static boolean moveSubClassImplementsToExtends(PsiClass oldInterface) throws IncorrectOperationException {
        Project project = oldInterface.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        PsiJavaCodeReferenceElement oldInterfaceReference = elementFactory.createClassReferenceElement(oldInterface);
        SearchScope searchScope = oldInterface.getUseScope();
        Query query = ClassInheritorsSearch.search((PsiClass)oldInterface, (SearchScope)searchScope, (boolean)false);
        Collection inheritors = query.findAll();
        boolean success = CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)inheritors, (boolean)false);
        if (!success) {
            return false;
        }
        for (PsiClass inheritor : inheritors) {
            PsiReferenceList implementsList = inheritor.getImplementsList();
            PsiReferenceList extendsList = inheritor.getExtendsList();
            if (implementsList == null) continue;
            ConvertInterfaceToClassIntention.moveReference(implementsList, extendsList, oldInterfaceReference);
        }
        return true;
    }

    private static void moveReference(@NotNull PsiReferenceList source, @Nullable PsiReferenceList target, @NotNull PsiJavaCodeReferenceElement reference) throws IncorrectOperationException {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/interfacetoclass/ConvertInterfaceToClassIntention.moveReference must not be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ipp/interfacetoclass/ConvertInterfaceToClassIntention.moveReference must not be null");
        }
        PsiJavaCodeReferenceElement[] implementsReferences = source.getReferenceElements();
        String qualifiedName = reference.getQualifiedName();
        for (PsiJavaCodeReferenceElement implementsReference : implementsReferences) {
            String implementsReferenceQualifiedName = implementsReference.getQualifiedName();
            if (!qualifiedName.equals(implementsReferenceQualifiedName)) continue;
            if (target != null) {
                target.add((PsiElement)implementsReference);
            }
            implementsReference.delete();
        }
    }
}

