/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitBranch;
import java.util.HashSet;

public class GitBranchesSearcher {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.GitBranchesSearcher");
    private GitBranch myLocal;
    private GitBranch myRemote;

    public GitBranchesSearcher(Project project, VirtualFile root, boolean findRemote) throws VcsException {
        LOG.debug("constructing, root: " + root.getPath() + " findRemote = " + findRemote);
        HashSet<GitBranch> usedBranches = new HashSet<GitBranch>();
        this.myLocal = GitBranch.current(project, root);
        LOG.debug("local: " + this.myLocal);
        if (this.myLocal == null) {
            return;
        }
        usedBranches.add(this.myLocal);
        GitBranch remote = this.myLocal;
        while (true) {
            if ((remote = remote.tracked(project, root)) == null) {
                LOG.debug("remote == null, exiting");
                return;
            }
            if (!findRemote || remote.isRemote()) {
                LOG.debug("remote found, isRemote: " + remote.isRemote() + " remoteName: " + remote.getFullName());
                this.myRemote = remote;
                return;
            }
            if (usedBranches.contains(remote)) {
                LOG.debug("loop found for: " + remote.getFullName() + ", exiting");
                return;
            }
            usedBranches.add(remote);
        }
    }

    public GitBranch getLocal() {
        return this.myLocal;
    }

    public GitBranch getRemote() {
        return this.myRemote;
    }
}

