/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitBranch;
import git4idea.GitRemote;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUIUtil {
    public static final String NO_CURRENT_BRANCH = GitBundle.getString("common.no.active.branch");

    private GitUIUtil() {
    }

    public static ListCellRenderer getVirtualFileListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                VirtualFile file = (VirtualFile)value;
                String text = file == null || !file.isValid() ? "(invalid)" : file.getPresentableUrl();
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        };
    }

    public static JTextField getTextField(JComboBox comboBox) {
        return (JTextField)comboBox.getEditor().getEditorComponent();
    }

    public static ListCellRenderer getGitRemoteListCellRenderer(final String defaultRemote, final boolean fetchUrl) {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                GitRemote remote = (GitRemote)value;
                if (value == null) {
                    text = GitBundle.getString("util.remote.renderer.none");
                } else if (".".equals(remote.name())) {
                    text = GitBundle.getString("util.remote.renderer.self");
                } else {
                    String key = defaultRemote != null && defaultRemote.equals(remote.name()) ? "util.remote.renderer.default" : "util.remote.renderer.normal";
                    text = GitBundle.message(key, remote.name(), fetchUrl ? remote.fetchUrl() : remote.pushUrl());
                }
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        };
    }

    public static void setupRootChooser(final @NotNull Project project, @NotNull List<VirtualFile> roots, @Nullable VirtualFile defaultRoot, final @NotNull JComboBox gitRootChooser, final @Nullable JLabel currentBranchLabel) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/ui/GitUIUtil.setupRootChooser must not be null");
        }
        if (roots == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/ui/GitUIUtil.setupRootChooser must not be null");
        }
        if (gitRootChooser == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/ui/GitUIUtil.setupRootChooser must not be null");
        }
        for (VirtualFile root : roots) {
            gitRootChooser.addItem(root);
        }
        gitRootChooser.setRenderer(GitUIUtil.getVirtualFileListCellRenderer());
        if (defaultRoot != null) {
            gitRootChooser.setSelectedItem(defaultRoot);
        }
        if (currentBranchLabel != null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        VirtualFile root = (VirtualFile)gitRootChooser.getSelectedItem();
                        assert (root != null) : "The root must not be null";
                        GitBranch current = GitBranch.current(project, root);
                        if (current == null) {
                            currentBranchLabel.setText(NO_CURRENT_BRANCH);
                        } else {
                            currentBranchLabel.setText(current.getName());
                        }
                    }
                    catch (VcsException ex) {
                        GitVcs.getInstance(project).showErrors(Collections.singletonList(ex), GitBundle.getString("merge.retrieving.branches"));
                    }
                }
            };
            listener.actionPerformed(null);
            gitRootChooser.addActionListener(listener);
        }
    }

    public static VirtualFile getRootFromRootChooser(JComboBox gitRootChooser) {
        return (VirtualFile)gitRootChooser.getSelectedItem();
    }

    public static void showOperationError(Project project, VcsException ex, @NonNls @NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/ui/GitUIUtil.showOperationError must not be null");
        }
        GitUIUtil.showOperationError(project, operation, ex.getMessage());
    }

    public static void showOperationErrors(Project project, Collection<VcsException> exs, @NonNls @NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/ui/GitUIUtil.showOperationErrors must not be null");
        }
        if (exs.size() == 1) {
            GitUIUtil.showOperationError(project, operation, exs.iterator().next().getMessage());
        } else if (exs.size() > 1) {
            StringBuilder b = new StringBuilder();
            for (VcsException ex : exs) {
                b.append(GitBundle.message("errors.message.item", ex.getMessage()));
            }
            GitUIUtil.showOperationError(project, operation, GitBundle.message("errors.message", b.toString()));
        }
    }

    public static void showOperationError(Project project, String operation, String message) {
        Messages.showErrorDialog((Project)project, (String)message, (String)GitBundle.message("error.occurred.during", operation));
    }

    public static void setupRemotes(Project project, VirtualFile root, JComboBox remoteCombobox, boolean fetchUrl) {
        GitBranch gitBranch = null;
        try {
            gitBranch = GitBranch.current(project, root);
        }
        catch (VcsException ex) {
            // empty catch block
        }
        String branch = gitBranch != null ? gitBranch.getName() : null;
        GitUIUtil.setupRemotes(project, root, branch, remoteCombobox, fetchUrl);
    }

    public static void setupRemotes(Project project, VirtualFile root, String currentBranch, JComboBox remoteCombobox, boolean fetchUrl) {
        try {
            List<GitRemote> remotes = GitRemote.list(project, root);
            String remote = null;
            if (currentBranch != null) {
                remote = GitConfigUtil.getValue(project, root, "branch." + currentBranch + ".remote");
            }
            remoteCombobox.setRenderer(GitUIUtil.getGitRemoteListCellRenderer(remote, fetchUrl));
            GitRemote toSelect = null;
            remoteCombobox.removeAllItems();
            for (GitRemote r : remotes) {
                remoteCombobox.addItem(r);
                if (!r.name().equals(remote)) continue;
                toSelect = r;
            }
            if (toSelect != null) {
                remoteCombobox.setSelectedItem(toSelect);
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(project).showErrors(Collections.singletonList(e), GitBundle.getString("pull.retrieving.remotes"));
        }
    }

    public static void imply(final JCheckBox checked, final boolean checkedState, final JCheckBox changed, final boolean impliedState) {
        ActionListener l = new ActionListener(){
            Boolean previousState;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checked.isSelected() == checkedState) {
                    if (this.previousState == null) {
                        this.previousState = changed.isSelected();
                    }
                    changed.setEnabled(false);
                    changed.setSelected(impliedState);
                } else {
                    changed.setEnabled(true);
                    if (this.previousState != null) {
                        changed.setSelected(this.previousState);
                        this.previousState = null;
                    }
                }
            }
        };
        checked.addActionListener(l);
        l.actionPerformed(null);
    }

    public static void exclusive(final JCheckBox first, final boolean firstState, final JCheckBox second, final boolean secondState) {
        ActionListener l = new ActionListener(){

            private void check(JCheckBox checked, boolean checkedState, JCheckBox changed, boolean impliedState) {
                if (checked.isSelected() == checkedState) {
                    changed.setSelected(impliedState);
                    changed.setEnabled(false);
                } else {
                    changed.setEnabled(true);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.check(first, firstState, second, !secondState);
                this.check(second, secondState, first, !firstState);
            }
        };
        first.addActionListener(l);
        second.addActionListener(l);
        l.actionPerformed(null);
    }

    public static void implyDisabled(final JCheckBox checked, final boolean checkedState, final JTextField changed) {
        ActionListener l = new ActionListener(){
            String previousState;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checked.isSelected() == checkedState) {
                    if (this.previousState == null) {
                        this.previousState = changed.getText();
                    }
                    changed.setEnabled(false);
                    changed.setText("");
                } else {
                    changed.setEnabled(true);
                    if (this.previousState != null) {
                        changed.setText(this.previousState);
                        this.previousState = null;
                    }
                }
            }
        };
        checked.addActionListener(l);
        l.actionPerformed(null);
    }
}

