/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.ArchetypeRegistryManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.OutputFileExists;
import org.apache.maven.archetype.exception.PomFileExists;
import org.apache.maven.archetype.exception.ProjectDirectoryExists;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.generator.FilesetArchetypeGenerator;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.DocumentException;

public class DefaultArchetypeGenerator
extends AbstractLogEnabled
implements ArchetypeGenerator {
    private ArchetypeRegistryManager archetypeRegistryManager;
    private ArchetypeArtifactManager archetypeArtifactManager;
    private FilesetArchetypeGenerator filesetGenerator;
    private OldArchetype oldArchetype;

    private void generateArchetype(ArchetypeGenerationRequest request, ArtifactRepository localRepository, String basedir) throws IOException, ArchetypeNotDefined, UnknownArchetype, ArchetypeNotConfigured, ProjectDirectoryExists, PomFileExists, OutputFileExists, XmlPullParserException, DocumentException, InvalidPackaging, ArchetypeGenerationFailure {
        if (!this.isArchetypeDefined(request)) {
            throw new ArchetypeNotDefined("The archetype is not defined");
        }
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        ArtifactRepository remoteRepo = null;
        if (request != null && request.getArchetypeRepository() != null) {
            remoteRepo = this.archetypeRegistryManager.createRepository(request.getArchetypeRepository(), request.getArchetypeArtifactId() + "-repo");
            repos.add(remoteRepo);
        }
        if (!this.archetypeArtifactManager.exists(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repos)) {
            throw new UnknownArchetype("The desired archetype does not exist (" + request.getArchetypeGroupId() + ":" + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion() + ")");
        }
        if (this.archetypeArtifactManager.isFileSetArchetype(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repos)) {
            this.processFileSetArchetype(request, remoteRepo, localRepository, basedir, repos);
        } else if (this.archetypeArtifactManager.isOldArchetype(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repos)) {
            this.processOldArchetype(request, remoteRepo, localRepository, basedir, repos);
        } else {
            throw new ArchetypeGenerationFailure("The defined artifact is not an archetype");
        }
    }

    public String getPackageAsDirectory(String packageName) {
        return StringUtils.replace((String)packageName, (String)".", (String)"/");
    }

    private boolean isArchetypeDefined(ArchetypeGenerationRequest request) {
        return StringUtils.isNotEmpty((String)request.getArchetypeGroupId()) && StringUtils.isNotEmpty((String)request.getArchetypeArtifactId()) && StringUtils.isNotEmpty((String)request.getArchetypeVersion());
    }

    private void processFileSetArchetype(ArchetypeGenerationRequest request, ArtifactRepository remoteRepo, ArtifactRepository localRepository, String basedir, List repositories) throws UnknownArchetype, ArchetypeNotConfigured, ProjectDirectoryExists, PomFileExists, OutputFileExists, ArchetypeGenerationFailure {
        File archetypeFile = this.archetypeArtifactManager.getArchetypeFile(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repositories);
        this.filesetGenerator.generateArchetype(request, archetypeFile, basedir);
    }

    private void processOldArchetype(ArchetypeGenerationRequest request, ArtifactRepository remoteRepo, ArtifactRepository localRepository, String basedir, List repositories) throws UnknownArchetype, ArchetypeGenerationFailure {
        ArchetypeDescriptor archetypeDescriptor = this.archetypeArtifactManager.getOldArchetypeDescriptor(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repositories);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("basedir", basedir);
        map.put("package", request.getPackage());
        map.put("packageName", request.getPackage());
        map.put("groupId", request.getGroupId());
        map.put("artifactId", request.getArtifactId());
        map.put("version", request.getVersion());
        this.oldArchetype.createArchetype(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), remoteRepo, localRepository, repositories, map);
    }

    public void generateArchetype(ArchetypeGenerationRequest request, ArchetypeGenerationResult result) {
        try {
            this.generateArchetype(request, request.getLocalRepository(), request.getOutputDirectory());
        }
        catch (IOException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (ArchetypeNotDefined ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (UnknownArchetype ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (ArchetypeNotConfigured ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (ProjectDirectoryExists ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (PomFileExists ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (OutputFileExists ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (XmlPullParserException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause((Exception)((Object)ex));
        }
        catch (DocumentException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause((Exception)((Object)ex));
        }
        catch (InvalidPackaging ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
        catch (ArchetypeGenerationFailure ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            result.setCause(ex);
        }
    }
}

