/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsRootEditor;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProviderImpl;
import com.intellij.cvsSupport2.connections.ssh.ui.SshPasswordDialog;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SshConnectionSettingsPanel {
    private TextFieldWithBrowseButton myPathToPrivateKeyFile;
    private JCheckBox myUsePrivateKeyFile;
    private JPanel myPanel;
    private JButton myChangePasswordButton;
    private final CvsRootEditor myRootProvider;

    public SshConnectionSettingsPanel(CvsRootEditor rootProvider) {
        this.myRootProvider = rootProvider;
        this.$$$setupUI$$$();
        this.myPathToPrivateKeyFile.addBrowseFolderListener(CvsBundle.message((String)"dialog.title.path.to.private.key.file", (Object[])new Object[0]), CvsBundle.message((String)"dialog.description.path.to.private.key.file", (Object[])new Object[0]), null, new FileChooserDescriptor(true, false, false, false, false, false));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshConnectionSettingsPanel.this.setPathToPPKEnabled();
            }
        };
        this.myUsePrivateKeyFile.addActionListener(actionListener);
        this.myChangePasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshConnectionSettingsPanel.this.changePassword();
            }
        });
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void updateFrom(SshSettings ssh_configuration) {
        this.myUsePrivateKeyFile.setSelected(ssh_configuration.USE_PPK);
        this.myPathToPrivateKeyFile.setText(ssh_configuration.PATH_TO_PPK);
        this.setPathToPPKEnabled();
    }

    private void setPathToPPKEnabled() {
        if (!this.myUsePrivateKeyFile.isSelected()) {
            this.myPathToPrivateKeyFile.setEnabled(false);
        } else {
            this.myPathToPrivateKeyFile.setEnabled(true);
        }
    }

    public void saveTo(SshSettings ssh_configuration) {
        if (this.myUsePrivateKeyFile.isSelected() && this.myPathToPrivateKeyFile.getText().trim().length() == 0) {
            throw new InputException(CvsBundle.message((String)"error.message.path.to.private.key.file.must.not.be.empty", (Object[])new Object[0]), (JComponent)this.myPathToPrivateKeyFile.getTextField());
        }
        ssh_configuration.USE_PPK = this.myUsePrivateKeyFile.isSelected();
        ssh_configuration.PATH_TO_PPK = this.myPathToPrivateKeyFile.getText().trim();
    }

    public boolean equalsTo(SshSettings ssh_configuration) {
        if (ssh_configuration.USE_PPK != this.myUsePrivateKeyFile.isSelected()) {
            return false;
        }
        return ssh_configuration.PATH_TO_PPK.equals(this.myPathToPrivateKeyFile.getText().trim());
    }

    private void changePassword() {
        SSHPasswordProviderImpl sshPasswordProvider = SSHPasswordProviderImpl.getInstance();
        if (!this.myUsePrivateKeyFile.isSelected()) {
            String cvsRoot = this.myRootProvider.getCurrentRoot();
            SshPasswordDialog sshPasswordDialog = new SshPasswordDialog(CvsBundle.message((String)"propmt.text.enter.password.for", (Object[])new Object[]{cvsRoot}));
            sshPasswordDialog.show();
            if (!sshPasswordDialog.isOK()) {
                return;
            }
            sshPasswordProvider.removePPKPasswordFor(cvsRoot);
            sshPasswordProvider.storePasswordForCvsRoot(cvsRoot, sshPasswordDialog.getPassword(), sshPasswordDialog.saveThisPassword());
        } else {
            String cvsRoot = this.myRootProvider.getCurrentRoot();
            SshPasswordDialog sshPasswordDialog = new SshPasswordDialog(CvsBundle.message((String)"prompt.text.enter.private.key.file.password.for", (Object[])new Object[]{cvsRoot}));
            sshPasswordDialog.show();
            if (!sshPasswordDialog.isOK()) {
                return;
            }
            sshPasswordProvider.removePasswordFor(cvsRoot);
            sshPasswordProvider.storePPKPasswordForCvsRoot(cvsRoot, sshPasswordDialog.getPassword(), sshPasswordDialog.saveThisPassword());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.configure.ssh.private.key.file"), 0, 0, null, null));
        this.myUsePrivateKeyFile = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.configure.ssh.use.private.key.file"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPathToPrivateKeyFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 8, 3, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myChangePasswordButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("button.configure.ssh.change.password"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

