/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ArrayUtil;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependsOnGroupsInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z1-9_\\(\\)]*)\"");
    private static final ProblemDescriptor[] EMPTY = new ProblemDescriptor[0];
    public JDOMExternalizableStringList groups = new JDOMExternalizableStringList();
    @NonNls
    public static String SHORT_NAME = "groupsTestNG";

    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnGroupsInspection.getGroupDisplayName must not return null");
        }
        return "TestNG";
    }

    @NotNull
    public String getDisplayName() {
        if ("Groups problem" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnGroupsInspection.getDisplayName must not return null");
        }
        return "Groups problem";
    }

    @NotNull
    public String getShortName() {
        String string = SHORT_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnGroupsInspection.getShortName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        LabeledComponent definedGroups = new LabeledComponent();
        definedGroups.setText("&Defined Groups");
        final JTextField textField = new JTextField(StringUtil.join((String[])ArrayUtil.toStringArray((Collection)this.groups), (String)","));
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DependsOnGroupsInspection.this.groups.clear();
                String[] groupsFromString = textField.getText().split("[, ]");
                DependsOnGroupsInspection.this.groups.addAll(Arrays.asList(groupsFromString));
            }
        });
        definedGroups.setComponent((JComponent)textField);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)definedGroups, "North");
        return optionsPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnGroupsInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnGroupsInspection.checkClass must not be null");
        }
        if (!psiClass.getContainingFile().isWritable()) {
            return null;
        }
        PsiAnnotation[] annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass);
        if (annotations.length == 0) {
            return EMPTY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiNameValuePair[] params;
            PsiNameValuePair dep = null;
            for (PsiNameValuePair param : params = annotation.getParameterList().getAttributes()) {
                if (param.getName() == null || !param.getName().matches("(groups|dependsOnGroups)")) continue;
                dep = param;
                break;
            }
            if (dep == null || dep.getValue() == null) continue;
            LOGGER.info("Found " + dep.getName() + " with: " + dep.getValue().getText());
            Matcher matcher = PATTERN.matcher(dep.getValue().getText());
            while (matcher.find()) {
                String methodName = matcher.group(1);
                if (this.groups.contains((Object)methodName)) continue;
                LOGGER.info("group doesn't exist:" + methodName);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)annotation, "Group '" + methodName + "' is undefined.", (LocalQuickFix)new GroupNameQuickFix(methodName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                problemDescriptors.add(descriptor);
            }
        }
        return problemDescriptors.toArray(new ProblemDescriptor[0]);
    }

    private class GroupNameQuickFix
    implements LocalQuickFix {
        String myGroupName;

        public GroupNameQuickFix(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix.<init> must not be null");
            }
            this.myGroupName = groupName;
        }

        @NotNull
        public String getName() {
            String string = "Add '" + this.myGroupName + "' as a defined test group.";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("TestNG" == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix.getFamilyName must not return null");
            }
            return "TestNG";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix.applyFix must not be null");
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix.applyFix must not be null");
            }
            DependsOnGroupsInspection.this.groups.add((Object)this.myGroupName);
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
            ((InspectionProfileImpl)inspectionProfile).isProperSetting(HighlightDisplayKey.find((String)SHORT_NAME));
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
        }
    }
}

