/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.resolver.BasicResolver;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.ResourceMDParser;
import fr.jayasoft.ivy.util.IvyPattern;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractResourceResolver
extends BasicResolver {
    private static final Map IVY_ARTIFACT_ATTRIBUTES = new HashMap();
    private List _ivyPatterns = new ArrayList();
    private List _artifactPatterns = new ArrayList();
    private boolean _m2compatible = false;

    protected ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this._ivyPatterns, DefaultArtifact.newIvyArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this._artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List patternList, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        ResolvedResource rres = null;
        Iterator iter = patternList.iterator();
        while (iter.hasNext() && rres == null) {
            String pattern = (String)iter.next();
            rres = this.findResourceUsingPattern(moduleRevision, pattern, artifact, rmdparser, date);
        }
        return rres;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    protected void logIvyNotFound(ModuleRevisionId mrid) {
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        Artifact artifact = DefaultArtifact.newIvyArtifact(mrid, null);
        this.logMdNotFound(mrid, artifact);
    }

    protected void logMdNotFound(ModuleRevisionId mrid, Artifact artifact) {
        String revisionToken = mrid.getRevision().startsWith("latest.") ? "[any " + mrid.getRevision().substring("latest.".length()) + "]" : "[" + mrid.getRevision() + "]";
        DefaultArtifact latestArtifact = new DefaultArtifact(ModuleRevisionId.newInstance(mrid, revisionToken), null, artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getExtraAttributes());
        if (this._ivyPatterns.isEmpty()) {
            this.logIvyAttempt("no ivy pattern => no attempt to find module descriptor file for " + mrid);
        } else {
            Iterator iter = this._ivyPatterns.iterator();
            while (iter.hasNext()) {
                String pattern = (String)iter.next();
                String resolvedFileName = IvyPatternHelper.substitute(pattern, artifact);
                this.logIvyAttempt(resolvedFileName);
                if (!this.getIvy().getVersionMatcher().isDynamic(mrid)) continue;
                resolvedFileName = IvyPatternHelper.substitute(pattern, latestArtifact);
                this.logIvyAttempt(resolvedFileName);
            }
        }
    }

    protected void logArtifactNotFound(Artifact artifact) {
        if (this._artifactPatterns.isEmpty() && artifact.getUrl() == null) {
            this.logArtifactAttempt(artifact, "no artifact pattern => no attempt to find artifact " + artifact);
        }
        Artifact used = artifact;
        if (this.isM2compatible()) {
            used = DefaultArtifact.cloneWithAnotherMrid(artifact, this.convertM2IdForResourceSearch(artifact.getModuleRevisionId()));
        }
        Iterator iter = this._artifactPatterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String resolvedFileName = IvyPatternHelper.substitute(pattern, used);
            this.logArtifactAttempt(artifact, resolvedFileName);
        }
        if (used.getUrl() != null) {
            this.logArtifactAttempt(artifact, used.getUrl().toString());
        }
    }

    protected Collection findNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        names.addAll(this.findIvyNames(tokenValues, token));
        if (this.isAllownomd()) {
            names.addAll(this.findArtifactNames(tokenValues, token));
        }
        return names;
    }

    protected Collection findIvyNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        this.findTokenValues(names, this.getIvyPatterns(), tokenValues, token);
        this.getIvy().filterIgnore(names);
        return names;
    }

    protected Collection findArtifactNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        this.findTokenValues(names, this.getArtifactPatterns(), tokenValues, token);
        this.getIvy().filterIgnore(names);
        return names;
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
    }

    public void addIvyPattern(String pattern) {
        this._ivyPatterns.add(pattern);
    }

    public void addArtifactPattern(String pattern) {
        this._artifactPatterns.add(pattern);
    }

    public List getIvyPatterns() {
        return Collections.unmodifiableList(this._ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this._artifactPatterns);
    }

    protected void setIvyPatterns(List ivyPatterns) {
        this._ivyPatterns = ivyPatterns;
    }

    protected void setArtifactPatterns(List artifactPatterns) {
        this._artifactPatterns = artifactPatterns;
    }

    public void addConfiguredIvy(IvyPattern p) {
        this._ivyPatterns.add(p.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p) {
        this._artifactPatterns.add(p.getPattern());
    }

    public void dumpConfig() {
        String p;
        super.dumpConfig();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        ListIterator iter = this.getIvyPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
        Message.debug("\t\tartifact patterns:");
        iter = this.getArtifactPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
    }

    public boolean isM2compatible() {
        return this._m2compatible;
    }

    public void setM2compatible(boolean m2compatible) {
        this._m2compatible = m2compatible;
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getExtraAttributes());
    }

    static {
        IVY_ARTIFACT_ATTRIBUTES.put("artifact", "ivy");
        IVY_ARTIFACT_ATTRIBUTES.put("type", "ivy");
        IVY_ARTIFACT_ATTRIBUTES.put("ext", "xml");
    }
}

