/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class BreakpointInfo
extends VMObject {
    private static CIntegerField origBytecodeField;
    private static CIntegerField bciField;
    private static CIntegerField nameIndexField;
    private static CIntegerField signatureIndexField;
    private static AddressField nextField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("BreakpointInfo");
        origBytecodeField = type.getCIntegerField("_orig_bytecode");
        bciField = type.getCIntegerField("_bci");
        nameIndexField = type.getCIntegerField("_name_index");
        signatureIndexField = type.getCIntegerField("_signature_index");
        nextField = type.getAddressField("_next");
    }

    public BreakpointInfo(Address addr) {
        super(addr);
    }

    public int getOrigBytecode() {
        return (int)origBytecodeField.getValue(this.addr);
    }

    public int getBCI() {
        return (int)bciField.getValue(this.addr);
    }

    public long getNameIndex() {
        return nameIndexField.getValue(this.addr);
    }

    public long getSignatureIndex() {
        return signatureIndexField.getValue(this.addr);
    }

    public BreakpointInfo getNext() {
        return (BreakpointInfo)VMObjectFactory.newObject(BreakpointInfo.class, nextField.getValue(this.addr));
    }

    public boolean match(Method m, int bci) {
        return bci == this.getBCI() && this.match(m);
    }

    public boolean match(Method m) {
        return this.getNameIndex() == m.getNameIndex() && this.getSignatureIndex() == m.getSignatureIndex();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                BreakpointInfo.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

