/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.CallSite;
import java.dyn.LinkagePermission;
import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.dyn.WrongMethodTypeException;
import sun.dyn.Access;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;
import sun.dyn.util.VerifyAccess;
import sun.reflect.Reflection;

public class Linkage {
    private static final Access IMPL_TOKEN = Access.getToken();
    public static final MethodType BOOTSTRAP_METHOD_TYPE = MethodType.methodType(CallSite.class, Class.class, String.class, MethodType.class);

    private Linkage() {
    }

    public static void registerBootstrapMethod(Class clazz, MethodHandle methodHandle) {
        Class clazz2 = Reflection.getCallerClass(2);
        VerifyAccess.checkBootstrapPrivilege(clazz2, clazz, "registerBootstrapMethod");
        Linkage.checkBSM(methodHandle);
        MethodHandleImpl.registerBootstrap(IMPL_TOKEN, clazz, methodHandle);
    }

    private static void checkBSM(MethodHandle methodHandle) {
        if (methodHandle == null) {
            throw MemberName.newIllegalArgumentException("null bootstrap method");
        }
        if (methodHandle.type() == BOOTSTRAP_METHOD_TYPE) {
            return;
        }
        throw new WrongMethodTypeException(methodHandle.toString());
    }

    public static void registerBootstrapMethod(Class<?> clazz, String string) {
        Class clazz2 = Reflection.getCallerClass(2);
        Linkage.registerBootstrapMethodLookup(clazz2, clazz, string);
    }

    public static void registerBootstrapMethod(String string) {
        Class clazz = Reflection.getCallerClass(2);
        Linkage.registerBootstrapMethodLookup(clazz, clazz, string);
    }

    private static void registerBootstrapMethodLookup(Class<?> clazz, Class<?> clazz2, String string) {
        MethodHandle methodHandle;
        MethodHandles.Lookup lookup = new MethodHandles.Lookup(IMPL_TOKEN, clazz);
        try {
            methodHandle = lookup.findStatic(clazz2, string, BOOTSTRAP_METHOD_TYPE);
        }
        catch (NoAccessException noAccessException) {
            throw new IllegalArgumentException("no such bootstrap method in " + clazz2 + ": " + string, noAccessException);
        }
        Linkage.checkBSM(methodHandle);
        MethodHandleImpl.registerBootstrap(IMPL_TOKEN, clazz, methodHandle);
    }

    public static MethodHandle getBootstrapMethod(Class clazz) {
        Class clazz2 = Reflection.getCallerClass(2);
        VerifyAccess.checkBootstrapPrivilege(clazz2, clazz, "getBootstrapMethod");
        return MethodHandleImpl.getBootstrap(IMPL_TOKEN, clazz);
    }

    public static Object invalidateAll() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkagePermission("invalidateAll"));
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static Object invalidateCallerClass(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkagePermission("invalidateAll", clazz));
        }
        throw new UnsupportedOperationException("NYI");
    }
}

