/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Principal;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.ServicePermission;
import javax.security.auth.login.LoginException;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.PrincipalName;
import sun.security.ssl.Krb5Proxy;

public class Krb5ProxyImpl
implements Krb5Proxy {
    @Override
    public Subject getClientSubject(AccessControlContext accessControlContext) throws LoginException {
        return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (AccessControlContext)accessControlContext);
    }

    @Override
    public Subject getServerSubject(AccessControlContext accessControlContext) throws LoginException {
        return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_SERVER, (AccessControlContext)accessControlContext);
    }

    @Override
    public SecretKey[] getServerKeys(AccessControlContext accessControlContext) throws LoginException {
        return Krb5Util.getKeys((GSSCaller)GSSCaller.CALLER_SSL_SERVER, null, (AccessControlContext)accessControlContext);
    }

    @Override
    public String getServerPrincipalName(SecretKey secretKey) {
        return ((KerberosKey)secretKey).getPrincipal().getName();
    }

    @Override
    public String getPrincipalHostName(Principal principal) {
        if (principal == null) {
            return null;
        }
        String string = null;
        try {
            PrincipalName principalName = new PrincipalName(principal.getName(), 3);
            String[] stringArray = principalName.getNameStrings();
            if (stringArray.length >= 2) {
                string = stringArray[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public Permission getServicePermission(String string, String string2) {
        return new ServicePermission(string, string2);
    }
}

