/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> filters) throws SearchCompiler.ParseError {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
        for (Filter filter : filters) {
            if (!filter.enable) continue;
            FilterInfo fi = new FilterInfo(filter);
            if (fi.isDelete) {
                if (filter.hiding) {
                    this.hiddenFilters.add(fi);
                    continue;
                }
                this.disabledFilters.add(fi);
                this.hiddenFilters.add(fi);
                continue;
            }
            if (filter.mode == SearchAction.SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(fi);
            if (!filter.hiding) continue;
            this.hiddenFilters.add(fi);
        }
    }

    private boolean getState(OsmPrimitive primitive, boolean hidden) {
        return hidden ? primitive.isDisabledAndHidden() : primitive.isDisabled();
    }

    private boolean allParentWaysFiltered(OsmPrimitive primitive, boolean hidden) {
        List<OsmPrimitive> refs = primitive.getReferrers();
        boolean foundWay = false;
        for (OsmPrimitive p : refs) {
            if (!(p instanceof Way)) continue;
            foundWay = true;
            if (this.getState(p, hidden)) continue;
            return false;
        }
        return foundWay;
    }

    private boolean oneParentWayNotFiltered(OsmPrimitive primitive, boolean hidden) {
        List<OsmPrimitive> refs = primitive.getReferrers();
        for (OsmPrimitive p : refs) {
            if (!(p instanceof Way) || this.getState(p, hidden)) continue;
            return true;
        }
        return false;
    }

    private boolean test(List<FilterInfo> filters, OsmPrimitive primitive, boolean hidden) {
        if (primitive.isIncomplete()) {
            return false;
        }
        boolean selected = false;
        boolean onlyInvertedFilters = true;
        for (FilterInfo fi : filters) {
            if (fi.isDelete && selected && fi.match.match(primitive)) {
                selected = false;
                continue;
            }
            if (fi.isDelete || selected && (!onlyInvertedFilters || fi.isInverted) || !fi.match.match(primitive)) continue;
            selected = true;
            onlyInvertedFilters = onlyInvertedFilters && fi.isInverted;
        }
        if (primitive instanceof Node) {
            if (!selected) {
                return !primitive.isTagged() && this.allParentWaysFiltered(primitive, hidden);
            }
            if (onlyInvertedFilters) {
                return selected && !this.oneParentWayNotFiltered(primitive, hidden);
            }
            return true;
        }
        return selected;
    }

    public boolean isHidden(OsmPrimitive primitive) {
        return this.test(this.hiddenFilters, primitive, true);
    }

    public boolean isDisabled(OsmPrimitive primitive) {
        return this.test(this.disabledFilters, primitive, false);
    }

    private static class FilterInfo {
        final SearchCompiler.Match match;
        final boolean isDelete;
        final boolean isInverted;

        FilterInfo(Filter filter) throws SearchCompiler.ParseError {
            this.isDelete = filter.mode == SearchAction.SearchMode.remove || filter.mode == SearchAction.SearchMode.in_selection;
            SearchCompiler.Match compiled = SearchCompiler.compile(filter.text, filter.caseSensitive, filter.regexSearch);
            this.match = filter.inverted ? new SearchCompiler.Not(compiled) : compiled;
            this.isInverted = filter.inverted;
        }
    }
}

