/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMerger
extends JPanel
implements Observer,
IConflictResolver {
    private static DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000000");
    public static final Color BGCOLOR_NO_CONFLICT = new Color(234, 234, 234);
    public static final Color BGCOLOR_UNDECIDED = new Color(255, 197, 197);
    public static final Color BGCOLOR_DECIDED = new Color(217, 255, 217);
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblMyCoordinates;
    private JLabel lblMergedCoordinates;
    private JLabel lblTheirCoordinates;
    private JLabel lblMyDeletedState;
    private JLabel lblMergedDeletedState;
    private JLabel lblTheirDeletedState;
    private JLabel lblMyReferrers;
    private JLabel lblTheirReferrers;
    private final PropertiesMergeModel model = new PropertiesMergeModel();

    protected JLabel buildValueLabel(String name) {
        JLabel lbl = new JLabel();
        lbl.setName(name);
        lbl.setHorizontalAlignment(0);
        lbl.setOpaque(true);
        lbl.setBorder(BorderFactory.createLoweredBevelBorder());
        return lbl;
    }

    protected void buildHeaderRow() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(10, 0, 10, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version"));
        this.lblMyVersion.setToolTipText(I18n.tr("Properties in my dataset, i.e. the local dataset"));
        this.add((Component)this.lblMyVersion, gc);
        gc.gridx = 3;
        gc.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version"));
        this.lblMergedVersion.setToolTipText(I18n.tr("Properties in the merged element. They will replace properties in my elements when merge decisions are applied."));
        this.add((Component)this.lblMergedVersion, gc);
        gc.gridx = 5;
        gc.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version"));
        this.lblTheirVersion.setToolTipText(I18n.tr("Properties in their dataset, i.e. the server dataset"));
        this.add((Component)this.lblTheirVersion, gc);
    }

    protected void buildCoordinateConflictRows() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Coordinates:")), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMyCoordinates = this.buildValueLabel("label.mycoordinates");
        this.add((Component)this.lblMyCoordinates, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMyCoordinatesAction actKeepMyCoordinates = new KeepMyCoordinatesAction();
        this.model.addObserver(actKeepMyCoordinates);
        JButton btnKeepMyCoordinates = new JButton(actKeepMyCoordinates);
        btnKeepMyCoordinates.setName("button.keepmycoordinates");
        this.add((Component)btnKeepMyCoordinates, gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMergedCoordinates = this.buildValueLabel("label.mergedcoordinates");
        this.add((Component)this.lblMergedCoordinates, gc);
        gc.gridx = 4;
        gc.gridy = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirCoordinatesAction actKeepTheirCoordinates = new KeepTheirCoordinatesAction();
        this.model.addObserver(actKeepTheirCoordinates);
        JButton btnKeepTheirCoordinates = new JButton(actKeepTheirCoordinates);
        this.add((Component)btnKeepTheirCoordinates, gc);
        gc.gridx = 5;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblTheirCoordinates = this.buildValueLabel("label.theircoordinates");
        this.add((Component)this.lblTheirCoordinates, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        UndecideCoordinateConflictAction actUndecideCoordinates = new UndecideCoordinateConflictAction();
        this.model.addObserver(actUndecideCoordinates);
        JButton btnUndecideCoordinates = new JButton(actUndecideCoordinates);
        this.add((Component)btnUndecideCoordinates, gc);
    }

    protected void buildDeletedStateConflictRows() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Deleted State:")), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMyDeletedState = this.buildValueLabel("label.mydeletedstate");
        this.add((Component)this.lblMyDeletedState, gc);
        gc.gridx = 2;
        gc.gridy = 3;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMyDeletedStateAction actKeepMyDeletedState = new KeepMyDeletedStateAction();
        this.model.addObserver(actKeepMyDeletedState);
        JButton btnKeepMyDeletedState = new JButton(actKeepMyDeletedState);
        btnKeepMyDeletedState.setName("button.keepmydeletedstate");
        this.add((Component)btnKeepMyDeletedState, gc);
        gc.gridx = 3;
        gc.gridy = 3;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMergedDeletedState = this.buildValueLabel("label.mergeddeletedstate");
        this.add((Component)this.lblMergedDeletedState, gc);
        gc.gridx = 4;
        gc.gridy = 3;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirDeletedStateAction actKeepTheirDeletedState = new KeepTheirDeletedStateAction();
        this.model.addObserver(actKeepTheirDeletedState);
        JButton btnKeepTheirDeletedState = new JButton(actKeepTheirDeletedState);
        btnKeepTheirDeletedState.setName("button.keeptheirdeletedstate");
        this.add((Component)btnKeepTheirDeletedState, gc);
        gc.gridx = 5;
        gc.gridy = 3;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblTheirDeletedState = this.buildValueLabel("label.theirdeletedstate");
        this.add((Component)this.lblTheirDeletedState, gc);
        gc.gridx = 3;
        gc.gridy = 4;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        UndecideDeletedStateConflictAction actUndecideDeletedState = new UndecideDeletedStateConflictAction();
        this.model.addObserver(actUndecideDeletedState);
        JButton btnUndecideDeletedState = new JButton(actUndecideDeletedState);
        btnUndecideDeletedState.setName("button.undecidedeletedstate");
        this.add((Component)btnUndecideDeletedState, gc);
    }

    protected void buildReferrersRow() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 7;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Referenced by:")), gc);
        gc.gridx = 1;
        gc.gridy = 7;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMyReferrers = this.buildValueLabel("label.myreferrers");
        this.add((Component)this.lblMyReferrers, gc);
        gc.gridx = 5;
        gc.gridy = 7;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblTheirReferrers = this.buildValueLabel("label.theirreferrers");
        this.add((Component)this.lblTheirReferrers, gc);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.buildHeaderRow();
        this.buildCoordinateConflictRows();
        this.buildDeletedStateConflictRows();
        this.buildReferrersRow();
    }

    public PropertiesMerger() {
        this.model.addObserver(this);
        this.build();
    }

    public String coordToString(LatLon coord) {
        if (coord == null) {
            return I18n.tr("(none)");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(COORD_FORMATTER.format(coord.lat())).append(",").append(COORD_FORMATTER.format(coord.lon())).append(")");
        return sb.toString();
    }

    public String deletedStateToString(Boolean deleted) {
        if (deleted == null) {
            return I18n.tr("(none)");
        }
        if (deleted.booleanValue()) {
            return I18n.tr("deleted");
        }
        return I18n.tr("not deleted");
    }

    public String referrersToString(List<OsmPrimitive> referrers) {
        if (referrers.isEmpty()) {
            return I18n.tr("(none)");
        }
        String str = "<html>";
        for (OsmPrimitive r : referrers) {
            str = str + r.getDisplayName(DefaultNameFormatter.getInstance()) + "<br>";
        }
        str = str + "</html>";
        return str;
    }

    protected void updateCoordinates() {
        this.lblMyCoordinates.setText(this.coordToString(this.model.getMyCoords()));
        this.lblMergedCoordinates.setText(this.coordToString(this.model.getMergedCoords()));
        this.lblTheirCoordinates.setText(this.coordToString(this.model.getTheirCoords()));
        if (!this.model.hasCoordConflict()) {
            this.lblMyCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedCoord()) {
            this.lblMyCoordinates.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirCoordinates.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedCoordinates.setBackground(BGCOLOR_DECIDED);
            this.lblTheirCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    protected void updateDeletedState() {
        this.lblMyDeletedState.setText(this.deletedStateToString(this.model.getMyDeletedState()));
        this.lblMergedDeletedState.setText(this.deletedStateToString(this.model.getMergedDeletedState()));
        this.lblTheirDeletedState.setText(this.deletedStateToString(this.model.getTheirDeletedState()));
        if (!this.model.hasDeletedStateConflict()) {
            this.lblMyDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedDeletedState()) {
            this.lblMyDeletedState.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirDeletedState.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedDeletedState.setBackground(BGCOLOR_DECIDED);
            this.lblTheirDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    protected void updateReferrers() {
        this.lblMyReferrers.setText(this.referrersToString(this.model.getMyReferrers()));
        this.lblMyReferrers.setBackground(BGCOLOR_NO_CONFLICT);
        this.lblTheirReferrers.setText(this.referrersToString(this.model.getTheirReferrers()));
        this.lblTheirReferrers.setBackground(BGCOLOR_NO_CONFLICT);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateCoordinates();
        this.updateDeletedState();
        this.updateReferrers();
    }

    public PropertiesMergeModel getModel() {
        return this.model;
    }

    @Override
    public void deletePrimitive(boolean deleted) {
        if (deleted) {
            if (this.model.getMergedCoords() == null) {
                this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
            }
        } else {
            this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict);
    }

    class UndecideDeletedStateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideDeletedStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between deleted state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepTheirDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepTheirDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their deleted state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepMyDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepMyDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my deleted state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class UndecideCoordinateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideCoordinateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between different coordinates"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepTheirCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepTheirCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their coordiates"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepMyCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepMyCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my coordiates"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }
}

