/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.text.MessageFormat;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlPanel
extends JPanel {
    private JEditorPane jepMessage;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.jepMessage = new JEditorPane("text/html", "");
        this.jepMessage.setOpaque(false);
        this.jepMessage.setEditable(false);
        Font f = UIManager.getFont("Label.font");
        StyleSheet ss = new StyleSheet();
        String rule = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), f.isBold() ? "bold" : "normal", f.isItalic() ? "italic" : "normal");
        rule = "body {" + rule + "}";
        rule = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), "bold", f.isItalic() ? "italic" : "normal");
        rule = "strong {" + rule + "}";
        ss.addRule(rule);
        ss.addRule("a {text-decoration: underline; color: blue}");
        ss.addRule("ul {margin-left: 1cm; list-style-type: disc}");
        HTMLEditorKit kit = new HTMLEditorKit();
        kit.setStyleSheet(ss);
        this.jepMessage.setEditorKit(kit);
        this.add((Component)this.jepMessage, "Center");
    }

    public HtmlPanel() {
        this.build();
    }

    public HtmlPanel(String text) {
        this();
        this.setText(text);
    }

    public JEditorPane getEditorPane() {
        return this.jepMessage;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.jepMessage.setText(text);
    }
}

