/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.ProtocolVersion;

public class KerberosClientKeyExchange
extends HandshakeMessage {
    private static final String IMPL_CLASS = "sun.security.ssl.krb5.KerberosClientKeyExchangeImpl";
    private static final Class<?> implClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

        @Override
        public Class<?> run() {
            try {
                return Class.forName(KerberosClientKeyExchange.IMPL_CLASS, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    });
    private final KerberosClientKeyExchange impl = this.createImpl();

    private KerberosClientKeyExchange createImpl() {
        if (this.getClass() == KerberosClientKeyExchange.class) {
            try {
                return (KerberosClientKeyExchange)implClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
        return null;
    }

    public KerberosClientKeyExchange() {
    }

    public KerberosClientKeyExchange(String string, boolean bl, AccessControlContext accessControlContext, ProtocolVersion protocolVersion, SecureRandom secureRandom) throws IOException {
        if (this.impl == null) {
            throw new IllegalStateException("Kerberos is unavailable");
        }
        this.init(string, bl, accessControlContext, protocolVersion, secureRandom);
    }

    public KerberosClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, SecretKey[] secretKeyArray) throws IOException {
        if (this.impl == null) {
            throw new IllegalStateException("Kerberos is unavailable");
        }
        this.init(protocolVersion, protocolVersion2, secureRandom, handshakeInStream, secretKeyArray);
    }

    @Override
    int messageType() {
        return 16;
    }

    @Override
    public int messageLength() {
        return this.impl.messageLength();
    }

    @Override
    public void send(HandshakeOutStream handshakeOutStream) throws IOException {
        this.impl.send(handshakeOutStream);
    }

    @Override
    public void print(PrintStream printStream) throws IOException {
        this.impl.print(printStream);
    }

    public void init(String string, boolean bl, AccessControlContext accessControlContext, ProtocolVersion protocolVersion, SecureRandom secureRandom) throws IOException {
        if (this.impl != null) {
            this.impl.init(string, bl, accessControlContext, protocolVersion, secureRandom);
        }
    }

    public void init(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, SecretKey[] secretKeyArray) throws IOException {
        if (this.impl != null) {
            this.impl.init(protocolVersion, protocolVersion2, secureRandom, handshakeInStream, secretKeyArray);
        }
    }

    public byte[] getUnencryptedPreMasterSecret() {
        return this.impl.getUnencryptedPreMasterSecret();
    }

    public Principal getPeerPrincipal() {
        return this.impl.getPeerPrincipal();
    }

    public Principal getLocalPrincipal() {
        return this.impl.getLocalPrincipal();
    }
}

