/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.nio.fs.DynamicFileAttributeView;

abstract class AbstractBasicFileAttributeView
implements BasicFileAttributeView,
DynamicFileAttributeView {
    private static final String SIZE_NAME = "size";
    private static final String CREATION_TIME_NAME = "creationTime";
    private static final String LAST_ACCESS_TIME_NAME = "lastAccessTime";
    private static final String LAST_MODIFIED_TIME_NAME = "lastModifiedTime";
    private static final String FILE_KEY_NAME = "fileKey";
    private static final String IS_DIRECTORY_NAME = "isDirectory";
    private static final String IS_REGULAR_FILE_NAME = "isRegularFile";
    private static final String IS_SYMBOLIC_LINK_NAME = "isSymbolicLink";
    private static final String IS_OTHER_NAME = "isOther";

    protected AbstractBasicFileAttributeView() {
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public Object getAttribute(String string) throws IOException {
        BasicFileAttributes basicFileAttributes = this.readAttributes();
        if (string.equals(SIZE_NAME)) {
            return basicFileAttributes.size();
        }
        if (string.equals(CREATION_TIME_NAME)) {
            return basicFileAttributes.creationTime();
        }
        if (string.equals(LAST_ACCESS_TIME_NAME)) {
            return basicFileAttributes.lastAccessTime();
        }
        if (string.equals(LAST_MODIFIED_TIME_NAME)) {
            return basicFileAttributes.lastModifiedTime();
        }
        if (string.equals(FILE_KEY_NAME)) {
            return basicFileAttributes.fileKey();
        }
        if (string.equals(IS_DIRECTORY_NAME)) {
            return basicFileAttributes.isDirectory();
        }
        if (string.equals(IS_REGULAR_FILE_NAME)) {
            return basicFileAttributes.isRegularFile();
        }
        if (string.equals(IS_SYMBOLIC_LINK_NAME)) {
            return basicFileAttributes.isSymbolicLink();
        }
        if (string.equals(IS_OTHER_NAME)) {
            return basicFileAttributes.isOther();
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        if (string.equals(LAST_MODIFIED_TIME_NAME)) {
            this.setTimes((FileTime)object, null, null);
            return;
        }
        if (string.equals(LAST_ACCESS_TIME_NAME)) {
            this.setTimes(null, (FileTime)object, null);
            return;
        }
        if (string.equals(CREATION_TIME_NAME)) {
            this.setTimes(null, null, (FileTime)object);
            return;
        }
        throw new UnsupportedOperationException("'" + string + "' is unknown or read-only attribute");
    }

    final void addBasicAttributesToBuilder(BasicFileAttributes basicFileAttributes, AttributesBuilder attributesBuilder) {
        if (attributesBuilder.match(SIZE_NAME)) {
            attributesBuilder.add(SIZE_NAME, basicFileAttributes.size());
        }
        if (attributesBuilder.match(CREATION_TIME_NAME)) {
            attributesBuilder.add(CREATION_TIME_NAME, basicFileAttributes.creationTime());
        }
        if (attributesBuilder.match(LAST_ACCESS_TIME_NAME)) {
            attributesBuilder.add(LAST_ACCESS_TIME_NAME, basicFileAttributes.lastAccessTime());
        }
        if (attributesBuilder.match(LAST_MODIFIED_TIME_NAME)) {
            attributesBuilder.add(LAST_MODIFIED_TIME_NAME, basicFileAttributes.lastModifiedTime());
        }
        if (attributesBuilder.match(FILE_KEY_NAME)) {
            attributesBuilder.add(FILE_KEY_NAME, basicFileAttributes.fileKey());
        }
        if (attributesBuilder.match(IS_DIRECTORY_NAME)) {
            attributesBuilder.add(IS_DIRECTORY_NAME, basicFileAttributes.isDirectory());
        }
        if (attributesBuilder.match(IS_REGULAR_FILE_NAME)) {
            attributesBuilder.add(IS_REGULAR_FILE_NAME, basicFileAttributes.isRegularFile());
        }
        if (attributesBuilder.match(IS_SYMBOLIC_LINK_NAME)) {
            attributesBuilder.add(IS_SYMBOLIC_LINK_NAME, basicFileAttributes.isSymbolicLink());
        }
        if (attributesBuilder.match(IS_OTHER_NAME)) {
            attributesBuilder.add(IS_OTHER_NAME, basicFileAttributes.isOther());
        }
    }

    @Override
    public Map<String, ?> readAttributes(String[] stringArray) throws IOException {
        AttributesBuilder attributesBuilder = AttributesBuilder.create(stringArray);
        this.addBasicAttributesToBuilder(this.readAttributes(), attributesBuilder);
        return attributesBuilder.unmodifiableMap();
    }

    static class AttributesBuilder {
        private Set<String> set = new HashSet<String>();
        private Map<String, Object> map = new HashMap<String, Object>();
        private boolean copyAll;

        private AttributesBuilder(String[] stringArray) {
            for (String string : stringArray) {
                if (string.equals("*")) {
                    this.copyAll = true;
                    continue;
                }
                this.set.add(string);
            }
        }

        static AttributesBuilder create(String[] stringArray) {
            return new AttributesBuilder(stringArray);
        }

        boolean match(String string) {
            if (this.copyAll) {
                return true;
            }
            return this.set.contains(string);
        }

        void add(String string, Object object) {
            this.map.put(string, object);
        }

        Map<String, Object> unmodifiableMap() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

