/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStringIO;
import org.jruby.RubyTime;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Adler32Ext;
import org.jruby.util.ByteList;
import org.jruby.util.CRC32Ext;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    public static final String ZLIB_VERSION = "1.2.3.3";
    public static final String VERSION = "0.6.0";
    public static final int MIN_WBITS = 8;
    public static final int MAX_WBITS = 15;
    public static final byte Z_NO_FLUSH = 0;
    public static final byte Z_SYNC_FLUSH = 2;
    public static final byte Z_FULL_FLUSH = 3;
    public static final byte Z_FINISH = 4;
    public static final byte Z_NO_COMPRESSION = 0;
    public static final byte Z_BEST_SPEED = 1;
    public static final byte Z_BEST_COMPRESSION = 9;
    public static final byte Z_DEFAULT_COMPRESSION = -1;
    public static final byte OS_MSDOS = 0;
    public static final byte OS_AMIGA = 1;
    public static final byte OS_VMS = 2;
    public static final byte OS_UNIX = 3;
    public static final byte OS_ATARI = 5;
    public static final byte OS_OS2 = 6;
    public static final byte OS_MACOS = 7;
    public static final byte OS_TOPS20 = 10;
    public static final byte OS_WIN32 = 11;
    public static final byte OS_VMCMS = 4;
    public static final byte OS_ZSYSTEM = 8;
    public static final byte OS_CPM = 9;
    public static final byte OS_QDOS = 12;
    public static final byte OS_RISCOS = 13;
    public static final byte OS_UNKNOWN = -1;
    public static final byte OS_CODE = 11;
    public static final byte Z_FILTERED = 1;
    public static final byte Z_HUFFMAN_ONLY = 2;
    public static final byte Z_DEFAULT_STRATEGY = 0;
    public static final byte Z_BINARY = 0;
    public static final byte Z_ASCII = 1;
    public static final byte Z_UNKNOWN = 2;
    private static final long[] crctab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public static RubyModule createZlibModule(Ruby runtime2) {
        RubyModule mZlib = runtime2.defineModule("Zlib");
        mZlib.defineAnnotatedMethods(RubyZlib.class);
        RubyClass cStandardError = runtime2.getStandardError();
        RubyClass cZlibError = mZlib.defineClassUnder("Error", cStandardError, cStandardError.getAllocator());
        mZlib.defineClassUnder("StreamEnd", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("StreamError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("BufError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("NeedDict", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("MemError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("VersionError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("DataError", cZlibError, cZlibError.getAllocator());
        RubyClass cGzFile = mZlib.defineClassUnder("GzipFile", runtime2.getObject(), RubyGzipFile.GZIPFILE_ALLOCATOR);
        cGzFile.defineAnnotatedMethods(RubyGzipFile.class);
        cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        RubyClass cGzError = cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        cGzFile.defineClassUnder("CRCError", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("NoFooter", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("LengthError", cGzError, cGzError.getAllocator());
        RubyClass cGzReader = mZlib.defineClassUnder("GzipReader", cGzFile, RubyGzipReader.GZIPREADER_ALLOCATOR);
        cGzReader.includeModule(runtime2.getEnumerable());
        cGzReader.defineAnnotatedMethods(RubyGzipReader.class);
        RubyClass cGzWriter = mZlib.defineClassUnder("GzipWriter", cGzFile, RubyGzipWriter.GZIPWRITER_ALLOCATOR);
        cGzWriter.defineAnnotatedMethods(RubyGzipWriter.class);
        mZlib.defineConstant("ZLIB_VERSION", runtime2.newString(ZLIB_VERSION));
        mZlib.defineConstant("VERSION", runtime2.newString(VERSION));
        mZlib.defineConstant("BINARY", runtime2.newFixnum(0));
        mZlib.defineConstant("ASCII", runtime2.newFixnum(1));
        mZlib.defineConstant("UNKNOWN", runtime2.newFixnum(2));
        mZlib.defineConstant("DEF_MEM_LEVEL", runtime2.newFixnum(8));
        mZlib.defineConstant("MAX_MEM_LEVEL", runtime2.newFixnum(9));
        mZlib.defineConstant("OS_UNIX", runtime2.newFixnum(3));
        mZlib.defineConstant("OS_UNKNOWN", runtime2.newFixnum(-1));
        mZlib.defineConstant("OS_CODE", runtime2.newFixnum(11));
        mZlib.defineConstant("OS_ZSYSTEM", runtime2.newFixnum(8));
        mZlib.defineConstant("OS_VMCMS", runtime2.newFixnum(4));
        mZlib.defineConstant("OS_VMS", runtime2.newFixnum(2));
        mZlib.defineConstant("OS_RISCOS", runtime2.newFixnum(13));
        mZlib.defineConstant("OS_MACOS", runtime2.newFixnum(7));
        mZlib.defineConstant("OS_OS2", runtime2.newFixnum(6));
        mZlib.defineConstant("OS_AMIGA", runtime2.newFixnum(1));
        mZlib.defineConstant("OS_QDOS", runtime2.newFixnum(12));
        mZlib.defineConstant("OS_WIN32", runtime2.newFixnum(11));
        mZlib.defineConstant("OS_ATARI", runtime2.newFixnum(5));
        mZlib.defineConstant("OS_MSDOS", runtime2.newFixnum(0));
        mZlib.defineConstant("OS_CPM", runtime2.newFixnum(9));
        mZlib.defineConstant("OS_TOPS20", runtime2.newFixnum(10));
        mZlib.defineConstant("DEFAULT_STRATEGY", runtime2.newFixnum(0));
        mZlib.defineConstant("FILTERED", runtime2.newFixnum(1));
        mZlib.defineConstant("HUFFMAN_ONLY", runtime2.newFixnum(2));
        mZlib.defineConstant("NO_FLUSH", runtime2.newFixnum(0));
        mZlib.defineConstant("SYNC_FLUSH", runtime2.newFixnum(2));
        mZlib.defineConstant("FULL_FLUSH", runtime2.newFixnum(3));
        mZlib.defineConstant("FINISH", runtime2.newFixnum(4));
        mZlib.defineConstant("NO_COMPRESSION", runtime2.newFixnum(0));
        mZlib.defineConstant("BEST_SPEED", runtime2.newFixnum(1));
        mZlib.defineConstant("DEFAULT_COMPRESSION", runtime2.newFixnum(-1));
        mZlib.defineConstant("BEST_COMPRESSION", runtime2.newFixnum(9));
        mZlib.defineConstant("MAX_WBITS", runtime2.newFixnum(15));
        RubyClass cZStream = mZlib.defineClassUnder("ZStream", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cZStream.defineAnnotatedMethods(ZStream.class);
        cZStream.undefineMethod("new");
        RubyClass cInflate = mZlib.defineClassUnder("Inflate", cZStream, Inflate.INFLATE_ALLOCATOR);
        cInflate.defineAnnotatedMethods(Inflate.class);
        RubyClass cDeflate = mZlib.defineClassUnder("Deflate", cZStream, Deflate.DEFLATE_ALLOCATOR);
        cDeflate.defineAnnotatedMethods(Deflate.class);
        runtime2.getKernel().callMethod(runtime2.getCurrentContext(), "require", (IRubyObject)runtime2.newString("stringio"));
        return mZlib;
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(IRubyObject recv2) {
        RubyBasicObject res = (RubyBasicObject)((RubyModule)recv2).fastGetConstant("ZLIB_VERSION");
        res.taint(recv2.getRuntime());
        return res;
    }

    @JRubyMethod(name={"crc32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        long crc2 = 0L;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            crc2 = RubyNumeric.num2long(args2[1]);
        }
        CRC32Ext ext2 = new CRC32Ext((int)crc2);
        if (bytes2 != null) {
            ext2.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        return recv2.getRuntime().newFixnum(ext2.getValue());
    }

    @JRubyMethod(name={"adler32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        int adler2 = 1;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            adler2 = RubyNumeric.fix2int(args2[1]);
        }
        Adler32Ext ext2 = new Adler32Ext(adler2);
        if (bytes2 != null) {
            ext2.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        return recv2.getRuntime().newFixnum(ext2.getValue());
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(IRubyObject recv2) {
        ArrayList<IRubyObject> ll = new ArrayList<IRubyObject>(crctab.length);
        for (int i = 0; i < crctab.length; ++i) {
            ll.add(recv2.getRuntime().newFixnum(crctab[i]));
        }
        return recv2.getRuntime().newArray(ll);
    }

    private static RaiseException newZlibError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.fastGetModule("Zlib").fastGetClass(klass);
        return new RaiseException(RubyException.newException(runtime2, errorClass, message2), true);
    }

    static RaiseException newZlibError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "Error", message2);
    }

    static RaiseException newStreamError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "StreamError", message2);
    }

    static RaiseException newDataError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "DataError", message2);
    }

    static void resetBuffer(ByteList l) {
        l.setBegin(0);
        l.setRealSize(0);
        l.invalidate();
    }

    @JRubyClass(name={"Zlib::GzipWriter"}, parent="Zlib::GzipFile")
    public static class RubyGzipWriter
    extends RubyGzipFile {
        protected static final ObjectAllocator GZIPWRITER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new RubyGzipWriter(runtime2, klass);
            }
        };
        private HeaderModifyableGZIPOutputStream io;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static RubyGzipWriter newGzipWriter(IRubyObject recv2, IRubyObject[] args2, Block block) {
            RubyClass klass = (RubyClass)recv2;
            RubyGzipWriter result = (RubyGzipWriter)klass.allocate();
            result.callInit(args2, block);
            return result;
        }

        @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, meta=true)
        public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            IRubyObject level2 = runtime2.getNil();
            IRubyObject strategy = runtime2.getNil();
            if (args2.length > 1) {
                level2 = args2[1];
                RubyGzipWriter.checkLevel(context.getRuntime(), RubyNumeric.fix2int(level2));
                if (args2.length > 2) {
                    strategy = args2[2];
                }
            }
            IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", args2[0], runtime2.newString("wb"));
            RubyGzipWriter gzio = RubyGzipWriter.newGzipWriter(recv2, new IRubyObject[]{io2, level2, strategy}, block);
            return RubyGzipFile.wrapBlock(context, (RubyGzipFile)gzio, block);
        }

        public RubyGzipWriter(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, required=1, rest=true, frame=true, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(IRubyObject[] args2, Block unusedBlock) {
            this.realIo = (RubyObject)args2[0];
            try {
                this.io = new HeaderModifyableGZIPOutputStream(this.realIo);
                return this;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            if (!this.closed) {
                try {
                    this.io.close();
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"append", "<<"}, required=1)
        public IRubyObject append(IRubyObject p1) {
            this.write(p1);
            return this;
        }

        @JRubyMethod(name={"printf"}, required=1, rest=true)
        public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
            this.write(RubyKernel.sprintf(context, this, args2));
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"print"}, rest=true)
        public IRubyObject print(IRubyObject[] args2) {
            IRubyObject sep;
            if (args2.length != 0) {
                int j = args2.length;
                for (int i = 0; i < j; ++i) {
                    this.write(args2[i]);
                }
            }
            if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
                this.write(sep);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"pos", "tell"})
        public IRubyObject pos() {
            return RubyFixnum.int2fix(this.getRuntime(), this.io.pos());
        }

        @JRubyMethod(name={"orig_name="}, required=1)
        public IRubyObject set_orig_name(IRubyObject obj) {
            if (this.io.headerIsWritten()) {
                throw RubyGzipWriter.newGzipFileError(this.getRuntime(), "header is already written");
            }
            this.nullFreeOrigName = obj.convertToString();
            this.ensureNonNull(this.nullFreeOrigName);
            return obj;
        }

        @JRubyMethod(name={"comment="}, required=1)
        public IRubyObject set_comment(IRubyObject obj) {
            if (this.io.headerIsWritten()) {
                throw RubyGzipWriter.newGzipFileError(this.getRuntime(), "header is already written");
            }
            this.nullFreeComment = obj.convertToString();
            this.ensureNonNull(this.nullFreeComment);
            return obj;
        }

        private void ensureNonNull(RubyString obj) {
            String str = obj.toString();
            if (str.indexOf(0) >= 0) {
                String trim = str.substring(0, str.toString().indexOf(0));
                obj.setValue(new ByteList(trim.getBytes()));
            }
        }

        @JRubyMethod(name={"putc"}, required=1)
        public IRubyObject putc(IRubyObject p1) {
            try {
                this.io.write(RubyNumeric.fix2int(p1));
                return p1;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"puts"}, rest=true)
        public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
            RubyStringIO sio = (RubyStringIO)this.getRuntime().fastGetClass("StringIO").newInstance(context, new IRubyObject[0], Block.NULL_BLOCK);
            sio.puts(context, args2);
            this.write(sio.string());
            return this.getRuntime().getNil();
        }

        public IRubyObject finish() {
            if (!this.finished) {
                try {
                    this.io.finish();
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            this.finished = true;
            return this.realIo;
        }

        @JRubyMethod(name={"flush"}, optional=1)
        public IRubyObject flush(IRubyObject[] args2) {
            if (args2.length == 0 || args2[0].isNil() || RubyNumeric.fix2int(args2[0]) != 0) {
                try {
                    this.io.flush();
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"mtime="}, required=1)
        public IRubyObject set_mtime(IRubyObject arg2) {
            if (this.io.headerIsWritten()) {
                throw RubyGzipWriter.newGzipFileError(this.getRuntime(), "header is already written");
            }
            if (arg2 instanceof RubyTime) {
                this.mtime = (RubyTime)arg2;
            } else if (!arg2.isNil()) {
                this.mtime.setDateTime(new DateTime(RubyNumeric.fix2long(arg2) * 1000L));
            }
            this.io.setModifiedTime(this.mtime.to_i().getLongValue());
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"crc"})
        public IRubyObject crc() {
            return this.getRuntime().newFixnum(this.io.crc());
        }

        @JRubyMethod(name={"write"}, required=1)
        public IRubyObject write(IRubyObject p1) {
            ByteList bytes2 = p1.asString().getByteList();
            try {
                this.io.write(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
                return this.getRuntime().newFixnum(bytes2.length());
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        public class HeaderModifyableGZIPOutputStream
        extends DeflaterOutputStream {
            private IRubyObject io;
            private long position;
            private CRC32 checksum;
            private boolean headerIsWritten;
            private long modifiedTime;
            private static final int DEFAULT_BUFFER_SIZE = 512;

            public HeaderModifyableGZIPOutputStream(IRubyObject io2) throws IOException {
                super((OutputStream)new IOOutputStream(io2, false, false), new Deflater(-1, true), 512);
                this.checksum = new CRC32();
                this.headerIsWritten = false;
                this.modifiedTime = System.currentTimeMillis();
                this.io = io2;
                this.position = 0L;
            }

            public void close() throws IOException {
                if (!RubyGzipWriter.this.closed) {
                    this.finish();
                    RubyGzipWriter.this.closed = true;
                }
                if (this.io.respondsTo("close")) {
                    this.io.callMethod(this.io.getRuntime().getCurrentContext(), "close");
                }
            }

            public synchronized void write(byte[] bytes2, int offset2, int length2) throws IOException {
                this.writeHeaderIfNeeded();
                super.write(bytes2, offset2, length2);
                this.checksum.update(bytes2, offset2, length2);
                this.position += (long)length2;
            }

            public void finish() throws IOException {
                this.writeHeaderIfNeeded();
                super.finish();
                this.writeTrailer();
            }

            public void setModifiedTime(long newModifiedTime) {
                this.modifiedTime = newModifiedTime;
            }

            public boolean headerIsWritten() {
                return this.headerIsWritten;
            }

            public long crc() {
                return this.checksum.getValue();
            }

            public long pos() {
                return this.position;
            }

            private void writeHeaderIfNeeded() throws IOException {
                if (!this.headerIsWritten) {
                    this.writeHeader();
                    this.headerIsWritten = true;
                }
            }

            private void writeHeader() throws IOException {
                byte flags = 0;
                byte extraflags = 0;
                if (RubyGzipWriter.this.nullFreeOrigName != null) {
                    flags = (byte)(flags | 8);
                }
                if (RubyGzipWriter.this.nullFreeComment != null) {
                    flags = (byte)(flags | 0x10);
                }
                if (RubyGzipWriter.this.level == 1) {
                    extraflags = (byte)(extraflags | 4);
                } else if (RubyGzipWriter.this.level == 9) {
                    extraflags = (byte)(extraflags | 2);
                }
                byte[] header = new byte[]{31, -117, 8, flags, (byte)this.modifiedTime, (byte)(this.modifiedTime >> 8), (byte)(this.modifiedTime >> 16), (byte)(this.modifiedTime >> 24), extraflags, 11};
                this.out.write(header);
                if (RubyGzipWriter.this.nullFreeOrigName != null) {
                    this.out.write(RubyGzipWriter.this.nullFreeOrigName.toString().getBytes());
                    this.out.write(0);
                }
                if (RubyGzipWriter.this.nullFreeComment != null) {
                    this.out.write(RubyGzipWriter.this.nullFreeComment.toString().getBytes());
                    this.out.write(0);
                }
            }

            private void writeTrailer() throws IOException {
                int originalDataSize = this.def.getTotalIn();
                int checksumInt = (int)this.checksum.getValue();
                byte[] trailer = new byte[]{(byte)checksumInt, (byte)(checksumInt >> 8), (byte)(checksumInt >> 16), (byte)(checksumInt >> 24), (byte)originalDataSize, (byte)(originalDataSize >> 8), (byte)(originalDataSize >> 16), (byte)(originalDataSize >> 24)};
                this.out.write(trailer);
            }
        }
    }

    @JRubyClass(name={"Zlib::GzipReader"}, parent="Zlib::GzipFile", include={"Enumerable"})
    public static class RubyGzipReader
    extends RubyGzipFile {
        protected static final ObjectAllocator GZIPREADER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new RubyGzipReader(runtime2, klass);
            }
        };
        private int line;
        private long position;
        private HeaderReadableGZIPInputStream io;
        private InputStream bufferedStream;
        private static final int BUFF_SIZE = 4096;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static RubyGzipReader newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
            RubyClass klass = (RubyClass)recv2;
            RubyGzipReader result = (RubyGzipReader)klass.allocate();
            result.callInit(args2, block);
            return result;
        }

        @JRubyMethod(name={"open"}, required=1, frame=true, meta=true)
        public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject filename2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", filename2, runtime2.newString("rb"));
            RubyGzipReader gzio = RubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
            return RubyGzipFile.wrapBlock(context, (RubyGzipFile)gzio, block);
        }

        public RubyGzipReader(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, required=1, frame=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(IRubyObject arg2, Block unusedBlock) {
            this.realIo = arg2;
            this.line = 0;
            this.position = 0L;
            this.io = new HeaderReadableGZIPInputStream(new CountingIOInputStream(this.realIo));
            this.bufferedStream = new BufferedInputStream(this.io);
            return this;
        }

        @JRubyMethod(name={"rewind"})
        public IRubyObject rewind() {
            Ruby rt = this.getRuntime();
            this.realIo.callMethod(rt.getCurrentContext(), "seek", new IRubyObject[]{rt.newFixnum(-this.io.pos()), rt.newFixnum(1)});
            this.initialize(this.realIo, Block.NULL_BLOCK);
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"lineno"})
        public IRubyObject lineno() {
            return this.getRuntime().newFixnum(this.line);
        }

        @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
        public IRubyObject readline(ThreadContext context) {
            IRubyObject dst = this.gets(context, new IRubyObject[0]);
            if (dst.isNil()) {
                throw this.getRuntime().newEOFError();
            }
            return dst;
        }

        private IRubyObject internalGets(IRubyObject[] args2) throws IOException {
            ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (args2.length > 0) {
                sep = args2[0].convertToString().getByteList();
            }
            return this.internalSepGets(sep);
        }

        private IRubyObject internalSepGets(ByteList sep) throws IOException {
            ByteList result = new ByteList();
            int ce = this.bufferedStream.read();
            while (ce != -1 && sep.indexOf(ce) == -1) {
                result.append((byte)ce);
                ce = this.bufferedStream.read();
            }
            if (0 == result.length() && -1 == ce) {
                return this.getRuntime().getNil();
            }
            ++this.line;
            this.position = result.length();
            result.append(sep);
            return RubyString.newString(this.getRuntime(), result);
        }

        @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
        public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
            try {
                IRubyObject result = this.internalGets(args2);
                if (!result.isNil()) {
                    context.getCurrentScope().setLastLine(result);
                }
                return result;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"read"}, optional=1)
        public IRubyObject read(IRubyObject[] args2) {
            try {
                if (args2.length == 0 || args2[0].isNil()) {
                    ByteList val = new ByteList(10);
                    byte[] buffer = new byte[4096];
                    int read2 = this.bufferedStream.read(buffer);
                    while (read2 != -1) {
                        val.append(buffer, 0, read2);
                        read2 = this.bufferedStream.read(buffer);
                    }
                    this.position += (long)val.length();
                    return RubyString.newString(this.getRuntime(), val);
                }
                int len = RubyNumeric.fix2int(args2[0]);
                if (len < 0) {
                    throw this.getRuntime().newArgumentError("negative length " + len + " given");
                }
                if (len > 0) {
                    byte[] buffer = new byte[len];
                    int toRead = len;
                    int offset2 = 0;
                    int read3 = 0;
                    while (toRead > 0) {
                        read3 = this.bufferedStream.read(buffer, offset2, toRead);
                        if (read3 == -1) {
                            if (offset2 != 0) break;
                            return this.getRuntime().getNil();
                        }
                        toRead -= read3;
                        offset2 += read3;
                    }
                    this.position += (long)buffer.length;
                    return RubyString.newString(this.getRuntime(), new ByteList(buffer, 0, len - toRead, false));
                }
                return RubyString.newEmptyString(this.getRuntime());
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"lineno="}, required=1)
        public IRubyObject set_lineno(IRubyObject lineArg) {
            this.line = RubyNumeric.fix2int(lineArg);
            return lineArg;
        }

        @JRubyMethod(name={"pos", "tell"})
        public IRubyObject pos() {
            return RubyFixnum.int2fix(this.getRuntime(), this.position);
        }

        @JRubyMethod(name={"readchar"})
        public IRubyObject readchar() {
            try {
                int value2 = this.bufferedStream.read();
                if (value2 == -1) {
                    throw this.getRuntime().newEOFError();
                }
                ++this.position;
                return this.getRuntime().newFixnum(value2);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"getc"})
        public IRubyObject getc() {
            try {
                int value2 = this.bufferedStream.read();
                if (value2 == -1) {
                    return this.getRuntime().getNil();
                }
                ++this.position;
                return this.getRuntime().newFixnum(value2);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        private boolean isEof() throws IOException {
            if (this.bufferedStream.available() == 0) {
                return true;
            }
            this.bufferedStream.mark(16);
            this.bufferedStream.read();
            this.bufferedStream.reset();
            return this.bufferedStream.available() == 0;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            if (!this.closed) {
                try {
                    this.bufferedStream.close();
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"eof"})
        public IRubyObject eof() {
            try {
                return this.isEof() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"eof?"})
        public IRubyObject eof_p() {
            return this.eof();
        }

        @JRubyMethod(name={"unused"})
        public IRubyObject unused() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"crc"})
        public IRubyObject crc() {
            return this.getRuntime().newFixnum(this.io.crc());
        }

        @JRubyMethod(name={"each"}, optional=1, frame=true)
        public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
            ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (args2.length > 0 && !args2[0].isNil()) {
                sep = args2[0].convertToString().getByteList();
            }
            try {
                IRubyObject result = this.internalSepGets(sep);
                while (!result.isNil()) {
                    block.yield(context, result);
                    result = this.internalSepGets(sep);
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"each_line"}, optional=1, frame=true)
        public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
            return this.each(context, args2, block);
        }

        @JRubyMethod(name={"ungetc"}, required=1)
        public IRubyObject ungetc(IRubyObject arg2) {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"readlines"}, optional=1)
        public IRubyObject readlines(IRubyObject[] args2) {
            ArrayList<IRubyObject> array = new ArrayList<IRubyObject>();
            if (args2.length != 0 && args2[0].isNil()) {
                array.add(this.read(new IRubyObject[0]));
            } else {
                ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
                if (args2.length > 0) {
                    sep = args2[0].convertToString().getByteList();
                }
                try {
                    IRubyObject result = this.internalSepGets(sep);
                    while (!result.isNil()) {
                        array.add(result);
                        result = this.internalSepGets(sep);
                    }
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            return this.getRuntime().newArray(array);
        }

        @JRubyMethod(name={"each_byte"}, frame=true)
        public IRubyObject each_byte(ThreadContext context, Block block) {
            try {
                int value2 = this.bufferedStream.read();
                while (value2 != -1) {
                    ++this.position;
                    block.yield(context, this.getRuntime().newFixnum(value2));
                    value2 = this.bufferedStream.read();
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            return this.getRuntime().getNil();
        }

        private class HeaderReadableGZIPInputStream
        extends InflaterInputStream {
            private static final int DEFAULT_BUFFER_SIZE = 512;
            private CountingIOInputStream countingStream;
            private CRC32 checksum;
            private boolean eof;

            public HeaderReadableGZIPInputStream(CountingIOInputStream io2) {
                super(new BufferedInputStream(io2), new Inflater(true), 512);
                this.checksum = new CRC32();
                this.eof = false;
                this.countingStream = io2;
                this.readHeader();
                this.eof = false;
                this.checksum.reset();
            }

            public int read() throws IOException {
                if (this.eof) {
                    return -1;
                }
                int ret = super.read();
                if (ret == -1) {
                    this.readTrailer();
                } else {
                    this.checksum.update((byte)(ret & 0xFF));
                }
                return ret;
            }

            public int read(byte[] b) throws IOException {
                if (this.eof) {
                    return -1;
                }
                int ret = super.read(b);
                if (ret == -1) {
                    this.readTrailer();
                } else {
                    this.checksum.update(b, 0, ret);
                }
                return ret;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (this.eof) {
                    return -1;
                }
                int ret = super.read(b, off, len);
                if (ret == -1) {
                    this.readTrailer();
                } else {
                    this.checksum.update(b, off, ret);
                }
                return ret;
            }

            public void close() throws IOException {
                if (!RubyGzipReader.this.closed) {
                    RubyGzipReader.this.closed = true;
                }
                if (this.countingStream.io.respondsTo("close")) {
                    this.countingStream.io.callMethod(this.countingStream.getRuntime().getCurrentContext(), "close");
                }
                this.eof = true;
            }

            public int pos() {
                return this.countingStream.pos();
            }

            public long crc() {
                return this.checksum.getValue();
            }

            private void readHeader() {
                this.checksum.reset();
                try {
                    if ((byte)this.readUByte() != 31) {
                        throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), "not in gzip format");
                    }
                    if ((byte)this.readUByte() != -117) {
                        throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), "not in gzip format");
                    }
                    byte b = (byte)this.readUByte();
                    if (b != 8) {
                        throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), "unsupported compression method " + b);
                    }
                    int flags = this.readUByte();
                    if ((flags & 2) != 0) {
                        throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), "multi-part gzip file is not supported");
                    }
                    if ((flags & 0x20) != 0) {
                        throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), "encrypted gzip file is not supported");
                    }
                    if ((flags & 0xFFFFFFC0) != 0) {
                        throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), "unknown flags " + flags);
                    }
                    RubyGzipReader.this.mtime.setDateTime(new DateTime(this.readUInt() * 1000L));
                    int extraflags = this.readUByte();
                    RubyGzipReader.this.level = (extraflags & 4) != 0 ? 1 : ((extraflags & 2) != 0 ? 9 : -1);
                    RubyGzipReader.this.osCode = (byte)this.readUByte();
                    if ((flags & 4) != 0) {
                        int size2 = this.readUShort();
                        byte[] extra = new byte[2 + size2];
                        this.readBytes(extra);
                    }
                    if ((flags & 8) != 0) {
                        RubyGzipReader.this.nullFreeOrigName = this.countingStream.getRuntime().newString(this.readNullTerminateString());
                        RubyGzipReader.this.nullFreeOrigName.setTaint(true);
                    }
                    if ((flags & 0x10) != 0) {
                        RubyGzipReader.this.nullFreeComment = this.countingStream.getRuntime().newString(this.readNullTerminateString());
                        RubyGzipReader.this.nullFreeComment.setTaint(true);
                    }
                }
                catch (IOException ioe) {
                    throw RubyGzipFile.newGzipFileError(this.countingStream.getRuntime(), ioe.getMessage());
                }
            }

            private int readUByte() throws IOException {
                int ret = this.in.read();
                if (ret == -1) {
                    throw new EOFException();
                }
                this.checksum.update((byte)(ret & 0xFF));
                return ret & 0xFF;
            }

            private int readUShort() throws IOException {
                return (this.readUByte() | this.readUByte() << 8) & 0xFFFF;
            }

            private long readUInt() throws IOException {
                return (long)(this.readUShort() | this.readUShort() << 16) & 0xFFFFFFFFL;
            }

            private void readBytes(byte[] bytes2) throws IOException {
                this.readBytes(bytes2, 0, bytes2.length, true);
            }

            private void readBytes(byte[] bytes2, int pos2, int len, boolean updateChecksum) throws IOException {
                if (bytes2.length < pos2 + len) {
                    throw new IllegalArgumentException();
                }
                while (len > 0) {
                    int ret = this.in.read(bytes2, pos2, len);
                    if (ret == -1) {
                        throw new EOFException();
                    }
                    if (updateChecksum) {
                        this.checksum.update(bytes2, pos2, ret);
                    }
                    pos2 += ret;
                    len -= ret;
                }
            }

            private String readNullTerminateString() throws IOException {
                int c;
                StringBuilder builder = new StringBuilder();
                while ((c = this.readUByte()) != 0) {
                    builder.append((char)c);
                }
                return builder.toString();
            }

            private void readTrailer() throws IOException {
                try {
                    long uint;
                    this.eof = true;
                    int rest2 = 8;
                    byte[] trailer = new byte[8];
                    int remaining = this.inf.getRemaining();
                    if (remaining > 0) {
                        System.arraycopy(this.buf, this.len - remaining, trailer, 0, remaining > 8 ? 8 : remaining);
                        rest2 -= remaining;
                    }
                    if (rest2 > 0) {
                        this.readBytes(trailer, 8 - rest2, rest2, false);
                    }
                    if ((uint = this.bytesToUInt(trailer, 0)) != this.checksum.getValue()) {
                        throw RubyGzipFile.newCRCError(this.countingStream.getRuntime(), "invalid compressed data -- crc error");
                    }
                    uint = this.bytesToUInt(trailer, 4);
                    if (uint != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
                        throw RubyGzipFile.newLengthError(this.countingStream.getRuntime(), "invalid compressed data -- length error");
                    }
                }
                catch (IOException ignored) {
                    throw RubyGzipFile.newNoFooter(this.countingStream.getRuntime(), "footer is not found");
                }
            }

            private long bytesToUInt(byte[] bytes2, int pos2) {
                if (bytes2.length < pos2 + 4) {
                    throw new IllegalArgumentException();
                }
                return (long)(bytes2[pos2++] & 0xFF | (bytes2[pos2++] & 0xFF) << 8 | (bytes2[pos2++] & 0xFF) << 16 | (bytes2[pos2++] & 0xFF) << 24) & 0xFFFFFFFFL;
            }
        }

        private static class CountingIOInputStream
        extends IOInputStream {
            private int position;
            private IRubyObject io;

            public CountingIOInputStream(IRubyObject io2) {
                super(io2);
                this.io = io2;
                this.position = 0;
            }

            public int read() throws IOException {
                int ret = super.read();
                if (ret != -1) {
                    ++this.position;
                }
                return ret;
            }

            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret != -1) {
                    this.position += ret;
                }
                return ret;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret != -1) {
                    this.position += ret;
                }
                return ret;
            }

            int pos() {
                return this.position;
            }

            Ruby getRuntime() {
                return this.io.getRuntime();
            }
        }

        @JRubyClass(name={"Zlib::GzipReader::Error"}, parent="Zlib::GzipReader")
        public static class Error {
        }
    }

    @JRubyClass(name={"Zlib::GzipFile"})
    public static class RubyGzipFile
    extends RubyObject {
        static final byte GZ_MAGIC_ID_1 = 31;
        static final byte GZ_MAGIC_ID_2 = -117;
        static final byte GZ_METHOD_DEFLATE = 8;
        static final byte GZ_FLAG_MULTIPART = 2;
        static final byte GZ_FLAG_EXTRA = 4;
        static final byte GZ_FLAG_ORIG_NAME = 8;
        static final byte GZ_FLAG_COMMENT = 16;
        static final byte GZ_FLAG_ENCRYPT = 32;
        static final byte GZ_FLAG_UNKNOWN_MASK = -64;
        static final byte GZ_EXTRAFLAG_FAST = 4;
        static final byte GZ_EXTRAFLAG_SLOW = 2;
        protected static final ObjectAllocator GZIPFILE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new RubyGzipFile(runtime2, klass);
            }
        };
        protected boolean closed = false;
        protected boolean finished = false;
        protected byte osCode = (byte)-1;
        protected int level = -1;
        protected RubyString nullFreeOrigName;
        protected RubyString nullFreeComment;
        protected IRubyObject realIo;
        protected RubyTime mtime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IRubyObject wrapBlock(ThreadContext context, RubyGzipFile instance, Block block) {
            if (block.isGiven()) {
                IRubyObject iRubyObject;
                block4: {
                    try {
                        iRubyObject = block.yield(context, instance);
                        Object var5_4 = null;
                        if (instance.isClosed()) break block4;
                        instance.close();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (!instance.isClosed()) {
                            instance.close();
                        }
                        throw throwable;
                    }
                }
                return iRubyObject;
            }
            return instance;
        }

        @JRubyMethod(name={"wrap"}, required=1, frame=true, meta=true)
        public static IRubyObject wrap(ThreadContext context, IRubyObject recv2, IRubyObject io2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            RubyGzipFile instance = recv2 == runtime2.getModule("Zlib").getClass("GzipWriter") ? RubyGzipWriter.newGzipWriter(recv2, new IRubyObject[]{io2}, block) : RubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
            return RubyGzipFile.wrapBlock(context, instance, block);
        }

        @JRubyMethod(name={"new"}, frame=true, meta=true)
        public static RubyGzipFile newInstance(IRubyObject recv2, Block block) {
            RubyClass klass = (RubyClass)recv2;
            RubyGzipFile result = (RubyGzipFile)klass.allocate();
            result.callInit(new IRubyObject[0], block);
            return result;
        }

        public RubyGzipFile(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            this.mtime = RubyTime.newTime(runtime2, new DateTime());
        }

        @JRubyMethod(name={"os_code"})
        public IRubyObject os_code() {
            return this.getRuntime().newFixnum(this.osCode & 0xFF);
        }

        @JRubyMethod(name={"closed?"})
        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        protected boolean isClosed() {
            return this.closed;
        }

        @JRubyMethod(name={"orig_name"})
        public IRubyObject orig_name() {
            if (this.closed) {
                throw RubyGzipFile.newGzipFileError(this.getRuntime(), "closed gzip stream");
            }
            return this.nullFreeOrigName == null ? this.getRuntime().getNil() : this.nullFreeOrigName;
        }

        @JRubyMethod(name={"to_io"})
        public IRubyObject to_io() {
            return this.realIo;
        }

        @JRubyMethod(name={"comment"})
        public IRubyObject comment() {
            if (this.closed) {
                throw RubyGzipFile.newGzipFileError(this.getRuntime(), "closed gzip stream");
            }
            return this.nullFreeComment == null ? this.getRuntime().getNil() : this.nullFreeComment;
        }

        @JRubyMethod(name={"crc"})
        public IRubyObject crc() {
            return this.getRuntime().newFixnum(0);
        }

        @JRubyMethod(name={"mtime"})
        public IRubyObject mtime() {
            return this.mtime;
        }

        @JRubyMethod(name={"sync"})
        public IRubyObject sync() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"finish"})
        public IRubyObject finish() {
            if (!this.finished) {
                // empty if block
            }
            this.finished = true;
            return this.realIo;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            return null;
        }

        @JRubyMethod(name={"level"})
        public IRubyObject level() {
            return this.getRuntime().newFixnum(this.level);
        }

        @JRubyMethod(name={"sync="}, required=1)
        public IRubyObject set_sync(IRubyObject ignored) {
            return this.getRuntime().getNil();
        }

        static void checkLevel(Ruby runtime2, int level2) {
            if (level2 < 0 || level2 > 9) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid level");
            }
        }

        static RaiseException newGzipFileError(Ruby runtime2, String message2) {
            return RubyGzipFile.newGzipFileError(runtime2, "Error", message2);
        }

        static RaiseException newCRCError(Ruby runtime2, String message2) {
            return RubyGzipFile.newGzipFileError(runtime2, "CRCError", message2);
        }

        static RaiseException newNoFooter(Ruby runtime2, String message2) {
            return RubyGzipFile.newGzipFileError(runtime2, "NoFooter", message2);
        }

        static RaiseException newLengthError(Ruby runtime2, String message2) {
            return RubyGzipFile.newGzipFileError(runtime2, "LengthError", message2);
        }

        private static RaiseException newGzipFileError(Ruby runtime2, String klass, String message2) {
            RubyClass errorClass = runtime2.fastGetModule("Zlib").fastGetClass("GzipFile").fastGetClass(klass);
            return new RaiseException(RubyException.newException(runtime2, errorClass, message2), true);
        }

        @JRubyClass(name={"Zlib::GzipFile::LengthError"}, parent="Zlib::GzipFile::Error")
        public static class LengthError
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::NoFooter"}, parent="Zlib::GzipFile::Error")
        public static class NoFooter
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::CRCError"}, parent="Zlib::GzipFile::Error")
        public static class CRCError
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::Error"}, parent="Zlib::Error")
        public static class Error {
        }
    }

    @JRubyClass(name={"Zlib::Deflate"}, parent="Zlib::ZStream")
    public static class Deflate
    extends ZStream {
        public static final int BASE_SIZE = 100;
        private Deflater flater;
        private ByteList collected;
        protected static final ObjectAllocator DEFLATE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new Deflate(runtime2, klass);
            }
        };

        @JRubyMethod(name={"deflate"}, required=1, optional=1, meta=true, backtrace=true)
        public static IRubyObject s_deflate(IRubyObject recv2, IRubyObject[] args2) {
            Ruby runtime2 = recv2.getRuntime();
            args2 = Arity.scanArgs(runtime2, args2, 1, 1);
            int level2 = -1;
            if (!args2[1].isNil()) {
                level2 = RubyNumeric.fix2int(args2[1]);
                Deflate.checkLevel(runtime2, level2);
            }
            RubyClass klass = (RubyClass)recv2;
            Deflate deflate2 = (Deflate)klass.allocate();
            deflate2.init(level2, 15, 8, 0);
            try {
                IRubyObject result = deflate2.deflate(args2[0].convertToString().getByteList(), 4);
                deflate2.close();
                return result;
            }
            catch (IOException ioe) {
                throw runtime2.newIOErrorFromException(ioe);
            }
        }

        public Deflate(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, optional=4, visibility=Visibility.PRIVATE, backtrace=true)
        public IRubyObject _initialize(IRubyObject[] args2) {
            args2 = Arity.scanArgs(this.getRuntime(), args2, 0, 4);
            int level2 = -1;
            int window_bits = 15;
            int memlevel = 8;
            int strategy = 0;
            if (!args2[0].isNil()) {
                level2 = RubyNumeric.fix2int(args2[0]);
                Deflate.checkLevel(this.getRuntime(), level2);
            }
            if (!args2[1].isNil()) {
                window_bits = RubyNumeric.fix2int(args2[1]);
                Deflate.checkWindowBits(this.getRuntime(), window_bits);
            }
            if (!args2[2].isNil()) {
                memlevel = RubyNumeric.fix2int(args2[2]);
            }
            if (!args2[3].isNil()) {
                strategy = RubyNumeric.fix2int(args2[3]);
            }
            this.init(level2, window_bits, memlevel, strategy);
            return this;
        }

        private void init(int level2, int win_bits, int memlevel, int strategy) {
            this.flater = new Deflater(level2, win_bits < 0);
            this.flater.setStrategy(strategy);
            this.collected = new ByteList(100);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize_copy(IRubyObject other) {
            if (this == other) {
                return this;
            }
            throw this.getRuntime().newNotImplementedError("Zlib::Deflate#dup is not supported");
        }

        @JRubyMethod(name={"<<"}, required=1)
        public IRubyObject append(IRubyObject arg2) {
            this.checkClosed();
            try {
                this.append(arg2.convertToString().getByteList());
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            return this;
        }

        @JRubyMethod(name={"params"}, required=2)
        public IRubyObject params(ThreadContext context, IRubyObject level2, IRubyObject strategy) {
            int l = RubyNumeric.fix2int(level2);
            Deflate.checkLevel(this.getRuntime(), l);
            int s = RubyNumeric.fix2int(strategy);
            Deflate.checkStrategy(this.getRuntime(), s);
            this.flater.setLevel(l);
            this.flater.setStrategy(s);
            this.run();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"set_dictionary"}, required=1, backtrace=true)
        public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
            try {
                this.flater.setDictionary(arg2.convertToString().getBytes());
                this.run();
                return arg2;
            }
            catch (IllegalArgumentException iae) {
                throw RubyZlib.newStreamError(context.getRuntime(), "stream error: " + iae.getMessage());
            }
        }

        @JRubyMethod(name={"flush"}, optional=1)
        public IRubyObject flush(IRubyObject[] args2) {
            int flush2 = 2;
            if (args2.length == 1 && !args2[0].isNil()) {
                flush2 = RubyNumeric.fix2int(args2[0]);
            }
            return this.flush(flush2);
        }

        @JRubyMethod(name={"deflate"}, required=1, optional=1)
        public IRubyObject deflate(IRubyObject[] args2) {
            args2 = Arity.scanArgs(this.getRuntime(), args2, 1, 1);
            if (this.internalFinished()) {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            ByteList data = null;
            if (!args2[0].isNil()) {
                data = args2[0].convertToString().getByteList();
            }
            int flush2 = 0;
            if (!args2[1].isNil()) {
                flush2 = RubyNumeric.fix2int(args2[1]);
            }
            try {
                return this.deflate(data, flush2);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        protected int internalTotalIn() {
            return this.flater.getTotalIn();
        }

        protected int internalTotalOut() {
            return this.flater.getTotalOut();
        }

        protected boolean internalStreamEndP() {
            return this.flater.finished();
        }

        protected void internalReset() {
            this.flater.reset();
            this.collected = new ByteList(100);
        }

        public boolean internalFinished() {
            return this.flater.finished();
        }

        protected int internalAdler() {
            return this.flater.getAdler();
        }

        protected IRubyObject internalFinish() {
            return this.finish();
        }

        protected void internalClose() {
            this.flater.end();
        }

        private void append(ByteList obj) throws IOException {
            this.flater.setInput(obj.getUnsafeBytes(), obj.getBegin(), obj.getRealSize());
            this.run();
        }

        private IRubyObject flush(int flush2) {
            if (flush2 == 0) {
                return RubyString.newEmptyString(this.getRuntime());
            }
            if (flush2 == 4) {
                this.flater.finish();
            }
            this.run();
            RubyString obj = RubyString.newString(this.getRuntime(), this.collected);
            this.collected = new ByteList(100);
            return obj;
        }

        private IRubyObject deflate(ByteList str, int flush2) throws IOException {
            if (null != str) {
                this.append(str);
            }
            return this.flush(flush2);
        }

        private IRubyObject finish() {
            return this.flush(4);
        }

        private void run() {
            int resultLength;
            if (this.flater.finished()) {
                return;
            }
            byte[] outp = new byte[1024];
            while (!this.flater.finished() && (resultLength = this.flater.deflate(outp)) != 0) {
                this.collected.append(outp, 0, resultLength);
                if (resultLength != outp.length) continue;
                outp = new byte[outp.length * 2];
            }
        }
    }

    @JRubyClass(name={"Zlib::Inflate"}, parent="Zlib::ZStream")
    public static class Inflate
    extends ZStream {
        public static final int BASE_SIZE = 100;
        private Inflater flater;
        private ByteList collected;
        private ByteList input;
        protected static final ObjectAllocator INFLATE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new Inflate(runtime2, klass);
            }
        };

        public Inflate(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JRubyMethod(name={"inflate"}, required=1, meta=true, backtrace=true)
        public static IRubyObject s_inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
            void var5_7;
            RubyClass klass = (RubyClass)recv2;
            Inflate inflate2 = (Inflate)klass.allocate();
            inflate2.init(15);
            try {
                inflate2.append(string2.convertToString().getByteList());
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                IRubyObject result = inflate2.finish(context);
                inflate2.close();
                throw throwable;
            }
            IRubyObject result = inflate2.finish(context);
            inflate2.close();
            return var5_7;
        }

        @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(IRubyObject[] args2) {
            int window_bits = 15;
            if (args2.length > 0 && !args2[0].isNil()) {
                window_bits = RubyNumeric.fix2int(args2[0]);
                Inflate.checkWindowBits(this.getRuntime(), window_bits);
            }
            this.init(window_bits);
            return this;
        }

        private void init(int window_bits) {
            this.flater = new Inflater(window_bits < 0);
            this.collected = new ByteList(100);
            this.input = new ByteList();
        }

        @JRubyMethod(name={"flush_next_out"})
        public IRubyObject flush_next_out(ThreadContext context) {
            return this.flushOutput(context.getRuntime());
        }

        private IRubyObject flushOutput(Ruby runtime2) {
            if (this.collected.getRealSize() > 0) {
                RubyString res = RubyString.newString(runtime2, this.collected.getUnsafeBytes(), this.collected.getBegin(), this.collected.getRealSize());
                RubyZlib.resetBuffer(this.collected);
                return res;
            }
            return RubyString.newEmptyString(runtime2);
        }

        @JRubyMethod(name={"<<"}, required=1)
        public IRubyObject append(ThreadContext context, IRubyObject arg2) {
            this.checkClosed();
            if (arg2.isNil()) {
                this.run(true);
            } else {
                this.append(arg2.convertToString().getByteList());
            }
            return this;
        }

        public void append(ByteList obj) {
            if (!this.internalFinished()) {
                byte[] bytes2 = obj.bytes();
                this.flater.setInput(bytes2);
                this.input = new ByteList(bytes2, false);
                this.run(false);
            } else {
                this.input.append(obj);
            }
        }

        @JRubyMethod(name={"sync_point?"})
        public IRubyObject sync_point_p() {
            return this.sync_point();
        }

        public IRubyObject sync_point() {
            return this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"set_dictionary"}, required=1, backtrace=true)
        public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
            try {
                return this.set_dictionary(arg2);
            }
            catch (IllegalArgumentException iae) {
                throw RubyZlib.newStreamError(context.getRuntime(), "stream error: " + iae.getMessage());
            }
        }

        private IRubyObject set_dictionary(IRubyObject str) {
            this.flater.setDictionary(str.convertToString().getBytes());
            this.run(false);
            return str;
        }

        @JRubyMethod(name={"inflate"}, required=1, backtrace=true)
        public IRubyObject inflate(ThreadContext context, IRubyObject string2) {
            ByteList data = null;
            if (!string2.isNil()) {
                data = string2.convertToString().getByteList();
            }
            return this.inflate(context, data);
        }

        public IRubyObject inflate(ThreadContext context, ByteList str) {
            if (null == str) {
                return this.internalFinish();
            }
            this.append(str);
            return this.flushOutput(context.getRuntime());
        }

        @JRubyMethod(name={"sync"}, required=1)
        public IRubyObject sync(ThreadContext context, IRubyObject string2) {
            block2: {
                try {
                    this.append(context, string2);
                }
                catch (RaiseException re) {
                    if (re.getException().getMetaClass().getRealClass().getName().equals("Zlib::DataError")) break block2;
                    throw re;
                }
            }
            return context.getRuntime().getFalse();
        }

        private void run(boolean finish2) {
            byte[] outp = new byte[1024];
            int resultLength = -1;
            while (!this.internalFinished() && resultLength != 0) {
                Ruby runtime2 = this.getRuntime();
                if (finish2 && this.flater.needsInput()) {
                    RubyClass errorClass = runtime2.fastGetModule("Zlib").fastGetClass("BufError");
                    throw new RaiseException(RubyException.newException(runtime2, errorClass, "buffer error"), true);
                }
                try {
                    resultLength = this.flater.inflate(outp);
                    if (this.flater.needsDictionary()) {
                        RubyClass errorClass = runtime2.fastGetModule("Zlib").fastGetClass("NeedDict");
                        throw new RaiseException(RubyException.newException(runtime2, errorClass, "need dictionary"));
                    }
                    if (this.input.getRealSize() > 0) {
                        int remaining = this.flater.getRemaining();
                        if (remaining > 0) {
                            this.input.view(this.input.getRealSize() - remaining, remaining);
                        } else {
                            RubyZlib.resetBuffer(this.input);
                        }
                    }
                }
                catch (DataFormatException ex) {
                    throw RubyZlib.newDataError(runtime2, "data error: " + ex.getMessage());
                }
                this.collected.append(outp, 0, resultLength);
                if (resultLength != outp.length) continue;
                outp = new byte[outp.length * 2];
            }
            if (this.internalFinished() && finish2 && this.input.getRealSize() > 0) {
                this.collected.append(this.input);
                RubyZlib.resetBuffer(this.input);
            }
            if (finish2) {
                this.flater.end();
            }
        }

        protected int internalTotalIn() {
            return this.flater.getTotalIn();
        }

        protected int internalTotalOut() {
            return this.flater.getTotalOut();
        }

        protected boolean internalStreamEndP() {
            return this.flater.finished();
        }

        protected void internalReset() {
            this.flater.reset();
        }

        protected boolean internalFinished() {
            return this.flater.finished();
        }

        protected int internalAdler() {
            return this.flater.getAdler();
        }

        protected IRubyObject internalFinish() {
            this.run(true);
            this.flater.end();
            RubyZlib.resetBuffer(this.input);
            return this.flushOutput(this.getRuntime());
        }

        protected void internalClose() {
            this.flater.end();
        }
    }

    @JRubyClass(name={"Zlib::ZStream"})
    public static abstract class ZStream
    extends RubyObject {
        protected boolean closed = false;

        protected abstract int internalTotalIn();

        protected abstract int internalTotalOut();

        protected abstract boolean internalStreamEndP();

        protected abstract void internalReset();

        protected abstract boolean internalFinished();

        protected abstract int internalAdler();

        protected abstract IRubyObject internalFinish();

        protected abstract void internalClose();

        public ZStream(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(Block unusedBlock) {
            return this;
        }

        @JRubyMethod(name={"flush_next_out"})
        public IRubyObject flush_next_out(ThreadContext context) {
            return RubyString.newEmptyString(context.getRuntime());
        }

        @JRubyMethod(name={"total_out"})
        public IRubyObject total_out() {
            this.checkClosed();
            return this.getRuntime().newFixnum(this.internalTotalOut());
        }

        @JRubyMethod(name={"stream_end?"})
        public IRubyObject stream_end_p() {
            return this.internalStreamEndP() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"data_type"})
        public IRubyObject data_type() {
            this.checkClosed();
            return this.getRuntime().fastGetModule("Zlib").fastGetConstant("UNKNOWN");
        }

        @JRubyMethod(name={"closed?", "ended?"})
        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"reset"})
        public IRubyObject reset() {
            this.checkClosed();
            this.internalReset();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"avail_out"})
        public IRubyObject avail_out() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"avail_out="}, required=1)
        public IRubyObject set_avail_out(IRubyObject p1) {
            this.checkClosed();
            return p1;
        }

        @JRubyMethod(name={"adler"})
        public IRubyObject adler() {
            this.checkClosed();
            return this.getRuntime().newFixnum(this.internalAdler());
        }

        @JRubyMethod(name={"finish"}, backtrace=true)
        public IRubyObject finish(ThreadContext context) {
            this.checkClosed();
            IRubyObject result = this.internalFinish();
            return result;
        }

        @JRubyMethod(name={"avail_in"})
        public IRubyObject avail_in() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"flush_next_in"})
        public IRubyObject flush_next_in(ThreadContext context) {
            return RubyString.newEmptyString(context.getRuntime());
        }

        @JRubyMethod(name={"total_in"})
        public IRubyObject total_in() {
            this.checkClosed();
            return this.getRuntime().newFixnum(this.internalTotalIn());
        }

        @JRubyMethod(name={"finished?"})
        public IRubyObject finished_p(ThreadContext context) {
            this.checkClosed();
            Ruby runtime2 = context.getRuntime();
            return this.internalFinished() ? runtime2.getTrue() : runtime2.getFalse();
        }

        @JRubyMethod(name={"close", "end"})
        public IRubyObject close() {
            this.checkClosed();
            this.internalClose();
            this.closed = true;
            return this.getRuntime().getNil();
        }

        void checkClosed() {
            if (this.closed) {
                throw RubyZlib.newZlibError(this.getRuntime(), "stream is not ready");
            }
        }

        static void checkLevel(Ruby runtime2, int level2) {
            if ((level2 < 0 || level2 > 9) && level2 != -1) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid level");
            }
        }

        static void checkWindowBits(Ruby runtime2, int wbits) {
            if ((wbits = Math.abs(wbits)) < 8 || wbits > 15) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid window bits");
            }
        }

        static void checkStrategy(Ruby runtime2, int strategy) {
            switch (strategy) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw RubyZlib.newStreamError(runtime2, "stream error: invalid strategy");
                }
            }
        }
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

