/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int baseVariableIndex;

    public StackBasedVariableCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        super(methodCompiler, method2, scope, specificArity, argsIndex, firstTempIndex);
        this.baseVariableIndex = firstTempIndex;
    }

    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        if (scope.getNumberOfVariables() > 0) {
            int start2;
            for (int i = start2 = scope.getRequiredArgs(); i < scope.getNumberOfVariables(); ++i) {
                this.methodCompiler.loadNil();
                this.assignLocalVariable(i, false);
            }
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    public void declareLocals(StaticScope scope, Label start2, Label end2) {
        String[] variables = scope.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            this.method.visitLocalVariable(variables[i], CodegenUtils.ci(IRubyObject.class), null, start2, end2, this.baseVariableIndex + i);
        }
    }

    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        bodyPrep.call(this.methodCompiler);
        if (scope.getNumberOfVariables() > 0) {
            int start2;
            for (int i = start2 = scope.getRequiredArgs(); i < scope.getNumberOfVariables(); ++i) {
                this.methodCompiler.loadNil();
                this.assignLocalVariable(i, false);
            }
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
    }

    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (scope != null) {
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.methodCompiler.loadNil();
                this.assignLocalVariable(i, false);
            }
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
        if (argsCallback != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.methodCompiler.getClosureIndex());
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, Block.class)));
            this.method.aload(this.argsIndex);
            argsCallback.call(this.methodCompiler);
        }
    }

    public void beginFlatClosure(CompilerCallback argsCallback, StaticScope scope) {
        throw new NotCompilableException("Can't have flat closure with stack-based scope");
    }

    public void assignLocalVariable(int index2, boolean expr) {
        if (expr) {
            this.method.dup();
        }
        this.method.astore(this.baseVariableIndex + index2);
    }

    private void assignLocalVariable(int index2, CompilerCallback value2, boolean expr) {
        value2.call(this.methodCompiler);
        this.assignLocalVariable(index2, expr);
    }

    public void assignLocalVariable(int index2, int depth, boolean expr) {
        if (depth == 0) {
            this.assignLocalVariable(index2, expr);
        } else {
            this.assignHeapLocal(depth, index2, expr);
        }
    }

    public void assignLocalVariable(int index2, int depth, CompilerCallback value2, boolean expr) {
        if (depth == 0) {
            this.assignLocalVariable(index2, value2, expr);
        } else {
            this.assignHeapLocal(value2, depth, index2, expr);
        }
    }

    public void retrieveLocalVariable(int index2) {
        this.method.aload(this.baseVariableIndex + index2);
    }

    public void retrieveLocalVariable(int index2, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index2);
        } else {
            this.retrieveHeapLocal(depth, index2);
        }
    }
}

