/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.DEFINE_CLASS_METHOD_Instr;
import org.jruby.compiler.ir.instructions.DEFINE_INSTANCE_METHOD_Instr;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.PUT_CONST_Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.SelfVariable;
import org.jruby.compiler.ir.operands.TemporaryClosureVariable;
import org.jruby.compiler.ir.operands.TemporaryVariable;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IR_ScopeImpl
implements IR_Scope {
    Operand _container;
    IR_Scope _lexicalParent;
    public final List<IR_Module> modules = new ArrayList<IR_Module>();
    public final List<IR_Class> classes = new ArrayList<IR_Class>();
    public final List<IRMethod> methods = new ArrayList<IRMethod>();
    private Map<String, String> aliases;
    private Map<String, Operand> contants;
    private int _nextMethodIndex;
    private int _nextClosureIndex;
    private Map<String, Integer> _nextVarIndex;

    private void init(IR_Scope lexicalParent, Operand container) {
        this._lexicalParent = lexicalParent;
        this._container = container;
        this._nextVarIndex = new HashMap<String, Integer>();
        this.contants = new HashMap<String, Operand>();
        this.aliases = new HashMap<String, String>();
        this._nextMethodIndex = 0;
        this._nextClosureIndex = 0;
    }

    public IR_ScopeImpl(IR_Scope lexicalParent, Operand container) {
        this.init(lexicalParent, container);
    }

    @Override
    public Operand getContainer() {
        return this._container;
    }

    @Override
    public IR_Scope getLexicalParent() {
        return this._lexicalParent;
    }

    @Override
    public int getNextClosureId() {
        ++this._nextClosureIndex;
        return this._nextClosureIndex;
    }

    public Variable getNewTemporaryClosureVariable(int closureId) {
        return new TemporaryClosureVariable(closureId, this.allocateNextPrefixedName("%cl_" + closureId));
    }

    @Override
    public Variable getNewTemporaryVariable() {
        return new TemporaryVariable(this.allocateNextPrefixedName("%v"));
    }

    @Override
    public Label getNewLabel(String prefix) {
        return new Label(prefix + "_" + this.allocateNextPrefixedName(prefix));
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    private int allocateNextPrefixedName(String prefix) {
        Integer index2 = this._nextVarIndex.get(prefix);
        if (index2 == null) {
            index2 = 0;
        }
        this._nextVarIndex.put(prefix, index2 + 1);
        return index2;
    }

    public int getAndIncrementMethodIndex() {
        ++this._nextMethodIndex;
        return this._nextMethodIndex;
    }

    @Override
    public Variable getSelf() {
        return new SelfVariable();
    }

    @Override
    public void addModule(IR_Module m) {
        this.setConstantValue(m._name, new MetaObject(m));
        this.modules.add(m);
    }

    @Override
    public void addClass(IR_Class c) {
        this.setConstantValue(c._name, new MetaObject(c));
        this.classes.add(c);
    }

    @Override
    public void addMethod(IRMethod m) {
        this.methods.add(m);
        if (IR_Module.isAClassRootMethod(m)) {
            return;
        }
        if (this instanceof IRMethod && ((IRMethod)this).isAClassRootMethod()) {
            IR_Module c = (IR_Module)((MetaObject)this._container)._scope;
            c.getRootMethod().addInstr(m.isInstanceMethod ? new DEFINE_INSTANCE_METHOD_Instr(c, m) : new DEFINE_CLASS_METHOD_Instr(c, m));
        } else if (m.isInstanceMethod && this instanceof IR_Module) {
            IR_Module c = (IR_Module)this;
            c.getRootMethod().addInstr(new DEFINE_INSTANCE_METHOD_Instr(c, m));
        } else if (!m.isInstanceMethod && this instanceof IR_Module) {
            IR_Module c = (IR_Module)this;
            c.getRootMethod().addInstr(new DEFINE_CLASS_METHOD_Instr(c, m));
        } else {
            throw new RuntimeException("Encountered method add in a non-class scope!");
        }
    }

    @Override
    public void addInstr(IR_Instr i) {
        throw new RuntimeException("Encountered instruction add in a non-execution scope!");
    }

    @Override
    public void recordMethodAlias(String newName, String oldName) {
        this.aliases.put(oldName, newName);
    }

    @Override
    public String unaliasMethodName(String name2) {
        String n = name2;
        String a = null;
        do {
            if ((a = this.aliases.get(n)) == null) continue;
            n = a;
        } while (a != null);
        return n;
    }

    public List<IR_Instr> getInstrs() {
        return null;
    }

    @Override
    public Operand getConstantValue(String constRef) {
        Operand cv = this.contants.get(constRef);
        Operand p2 = this._container;
        if (cv == null && p2 != null && p2 instanceof MetaObject) {
            if (((MetaObject)p2)._scope == null) {
                IR_Class coreClass = IR_Module.getCoreClass(constRef);
                return coreClass != null ? new MetaObject(coreClass) : null;
            }
            cv = ((MetaObject)p2)._scope.getConstantValue(constRef);
        }
        return cv;
    }

    @Override
    public void setConstantValue(String constRef, Operand val) {
        if (val.isConstant()) {
            this.contants.put(constRef, val);
        }
        if (this instanceof IR_Module) {
            ((IR_Module)this).getRootMethod().addInstr(new PUT_CONST_Instr(this, constRef, val));
        }
    }

    public Map getConstants() {
        return Collections.unmodifiableMap(this.contants);
    }

    public String toString() {
        return this.contants.isEmpty() ? "" : "\n  constants: " + this.contants;
    }

    protected void runCompilerPassOnNestedScopes(CompilerPass p2) {
        if (!this.modules.isEmpty()) {
            for (IR_Scope iR_Scope : this.modules) {
                iR_Scope.runCompilerPass(p2);
            }
        }
        if (!this.classes.isEmpty()) {
            for (IR_Scope iR_Scope : this.classes) {
                iR_Scope.runCompilerPass(p2);
            }
        }
        if (!this.methods.isEmpty()) {
            for (IR_Scope iR_Scope : this.methods) {
                iR_Scope.runCompilerPass(p2);
            }
        }
    }

    @Override
    public void runCompilerPass(CompilerPass p2) {
        boolean isPreOrder = p2.isPreOrder();
        if (isPreOrder) {
            p2.run(this);
        }
        this.runCompilerPassOnNestedScopes(p2);
        if (!isPreOrder) {
            p2.run(this);
        }
    }

    public String toStringInstrs() {
        return "";
    }

    public String toStringVariables() {
        return "";
    }
}

