/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class BackRefNode
extends Node {
    private final char type;

    public BackRefNode(ISourcePosition position, int type) {
        super(position, NodeType.BACKREFNODE);
        this.type = (char)type;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitBackRefNode(this);
    }

    public char getType() {
        return this.type;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        switch (this.type) {
            case '&': {
                return RubyRegexp.last_match(backref);
            }
            case '`': {
                return RubyRegexp.match_pre(backref);
            }
            case '\'': {
                return RubyRegexp.match_post(backref);
            }
            case '+': {
                return RubyRegexp.match_last(backref);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        return backref instanceof RubyMatchData ? "$" + this.type : null;
    }
}

