/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext;

import java.io.IOException;
import org.jruby.nb.Ruby;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.load.Library;

public class LateLoadingLibrary
implements Library {
    private final String libraryName;
    private final String className;
    private ClassLoader classLoader;

    public LateLoadingLibrary(String libraryName, String className, ClassLoader classLoader) {
        this.libraryName = libraryName;
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public synchronized void load(Ruby runtime, boolean wrap) throws IOException {
        try {
            if (this.classLoader == null && Ruby.isSecurityRestricted()) {
                this.classLoader = runtime.getInstanceConfig().getLoader();
            }
            Library library = (Library)this.classLoader.loadClass(this.className).newInstance();
            library.load(runtime, wrap);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw runtime.newLoadError("library `" + this.libraryName + "' could not be loaded: " + e);
        }
    }
}

