/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaAccessibleObject;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.ParameterTypes;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class JavaCallable
extends JavaAccessibleObject
implements ParameterTypes {
    public JavaCallable(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result) {
        result.defineAnnotatedMethods(JavaCallable.class);
    }

    public abstract int getArity();

    public abstract int getModifiers();

    @Override
    public abstract Class<?>[] getParameterTypes();

    @Override
    public abstract Class<?>[] getExceptionTypes();

    public abstract Type[] getGenericExceptionTypes();

    public abstract Type[] getGenericParameterTypes();

    public abstract Annotation[][] getParameterAnnotations();

    @Override
    public abstract boolean isVarArgs();

    public abstract String toGenericString();

    protected abstract String nameOnInspection();

    @JRubyMethod
    public final RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getArity());
    }

    @JRubyMethod
    public final RubyArray argument_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getParameterTypes());
    }

    @JRubyMethod
    public IRubyObject parameter_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getParameterTypes());
    }

    @JRubyMethod
    public IRubyObject exception_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getExceptionTypes());
    }

    @JRubyMethod
    public IRubyObject generic_parameter_types() {
        return Java.getInstance(this.getRuntime(), this.getGenericParameterTypes());
    }

    @JRubyMethod
    public IRubyObject generic_exception_types() {
        return Java.getInstance(this.getRuntime(), this.getGenericExceptionTypes());
    }

    @JRubyMethod
    public IRubyObject parameter_annotations() {
        return Java.getInstance(this.getRuntime(), this.getParameterAnnotations());
    }

    @JRubyMethod(name={"varargs?"})
    public RubyBoolean varargs_p() {
        return this.getRuntime().newBoolean(this.isVarArgs());
    }

    @JRubyMethod
    public RubyString to_generic_string() {
        return this.getRuntime().newString(this.toGenericString());
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        StringBuilder result = new StringBuilder();
        result.append(this.nameOnInspection());
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            result.append(',');
        }
        result.append(")>");
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isPublic(this.getModifiers()));
    }
}

