/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jruby.nb.util.JRubyFile;

public class JavaNameMangler {
    public static final Pattern PATH_SPLIT = Pattern.compile("[/\\\\]");

    public static String mangledFilenameForStartupClasspath(String filename) {
        if (filename.equals("-e")) {
            return "ruby/__dash_e__";
        }
        return JavaNameMangler.mangleFilenameForClasspath(filename, null, "", false);
    }

    public static String mangleFilenameForClasspath(String filename) {
        return JavaNameMangler.mangleFilenameForClasspath(filename, null, "ruby");
    }

    public static String mangleFilenameForClasspath(String filename, String parent, String prefix) {
        return JavaNameMangler.mangleFilenameForClasspath(filename, parent, prefix, true);
    }

    public static String mangleFilenameForClasspath(String filename, String parent, String prefix, boolean canonicalize) {
        try {
            String classPath = "";
            if (filename.indexOf("!") != -1) {
                String before = filename.substring(6, filename.indexOf("!"));
                classPath = canonicalize ? new JRubyFile(before + filename.substring(filename.indexOf("!") + 1)).getCanonicalPath().toString() : new JRubyFile(before + filename.substring(filename.indexOf("!") + 1)).toString();
            } else {
                try {
                    classPath = canonicalize ? new JRubyFile(filename).getCanonicalPath().toString() : new JRubyFile(filename).toString();
                }
                catch (IOException ioe) {
                    classPath = filename;
                }
            }
            if (parent != null && parent.length() > 0) {
                String parentPath;
                try {
                    parentPath = canonicalize ? new JRubyFile(parent).getCanonicalPath().toString() : new JRubyFile(parent).toString();
                }
                catch (IOException ioe) {
                    parentPath = parent;
                }
                if (!classPath.startsWith(parentPath)) {
                    throw new FileNotFoundException("File path " + classPath + " does not start with parent path " + parentPath);
                }
                int parentLength = parentPath.length();
                classPath = classPath.substring(parentLength);
            }
            String[] pathElements = PATH_SPLIT.split(classPath);
            StringBuilder newPath = new StringBuilder(prefix);
            for (String element : pathElements) {
                if (element.length() <= 0) continue;
                if (newPath.length() > 0) {
                    newPath.append("/");
                }
                if (!Character.isJavaIdentifierStart(element.charAt(0))) {
                    newPath.append("$");
                }
                newPath.append(JavaNameMangler.mangleStringForCleanJavaIdentifier(element));
            }
            int dotRbIndex = newPath.indexOf("_dot_rb");
            if (dotRbIndex != -1 && dotRbIndex == newPath.length() - 7) {
                newPath.delete(dotRbIndex, dotRbIndex + 7);
            }
            return newPath.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe);
        }
    }

    public static String mangleStringForCleanJavaIdentifier(String name) {
        char[] characters = name.toCharArray();
        StringBuilder cleanBuffer = new StringBuilder();
        boolean prevWasReplaced = false;
        block15: for (int i = 0; i < characters.length; ++i) {
            if (i == 0 && Character.isJavaIdentifierStart(characters[i]) || Character.isJavaIdentifierPart(characters[i])) {
                cleanBuffer.append(characters[i]);
                prevWasReplaced = false;
                continue;
            }
            if (!prevWasReplaced) {
                cleanBuffer.append("_");
            }
            prevWasReplaced = true;
            switch (characters[i]) {
                case '?': {
                    cleanBuffer.append("p_");
                    continue block15;
                }
                case '!': {
                    cleanBuffer.append("b_");
                    continue block15;
                }
                case '<': {
                    cleanBuffer.append("lt_");
                    continue block15;
                }
                case '>': {
                    cleanBuffer.append("gt_");
                    continue block15;
                }
                case '=': {
                    cleanBuffer.append("equal_");
                    continue block15;
                }
                case '[': {
                    if (i + 1 < characters.length && characters[i + 1] == ']') {
                        cleanBuffer.append("aref_");
                        ++i;
                        continue block15;
                    }
                    cleanBuffer.append("lbracket_");
                    continue block15;
                }
                case ']': {
                    cleanBuffer.append("rbracket_");
                    continue block15;
                }
                case '+': {
                    cleanBuffer.append("plus_");
                    continue block15;
                }
                case '-': {
                    cleanBuffer.append("minus_");
                    continue block15;
                }
                case '*': {
                    cleanBuffer.append("times_");
                    continue block15;
                }
                case '/': {
                    cleanBuffer.append("div_");
                    continue block15;
                }
                case '&': {
                    cleanBuffer.append("and_");
                    continue block15;
                }
                case '.': {
                    cleanBuffer.append("dot_");
                    continue block15;
                }
                default: {
                    cleanBuffer.append(Integer.toHexString(characters[i])).append("_");
                }
            }
        }
        return cleanBuffer.toString();
    }
}

