/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresentersProcessor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class DesignComponent {
    private final DesignDocument document;
    private final long componentID;
    private final TypeID type;
    private DesignComponent parentComponent;
    private final ArrayList<DesignComponent> children;
    private final HashMap<String, PropertyValue> properties;
    private final HashMap<String, PropertyValue> defaultProperties;
    private ComponentDescriptor componentDescriptor;
    private Lookup presenters;
    private PropertyValue referencePropertyValue;

    DesignComponent(DesignDocument document, long componentID, ComponentDescriptor componentDescriptor) {
        assert (Debug.isFriend(DesignDocument.class, "createRawComponent"));
        this.document = document;
        this.componentID = componentID;
        this.type = componentDescriptor.getTypeDescriptor().getThisType();
        assert (this.type.getKind() == TypeID.Kind.COMPONENT && this.type.getDimension() == 0);
        this.children = new ArrayList();
        this.properties = new HashMap();
        this.defaultProperties = new HashMap();
        this.referencePropertyValue = PropertyValue.createComponentReferenceCore(this);
        this.presenters = Lookup.EMPTY;
        this.setComponentDescriptor(componentDescriptor, false);
    }

    public ComponentDescriptor getComponentDescriptor() {
        assert (this.document.getTransactionManager().isAccess());
        return this.componentDescriptor;
    }

    void setComponentDescriptor(ComponentDescriptor componentDescriptor, boolean useUndo) {
        assert (Debug.isFriend(DesignDocument.class, "updateDescriptorReferences") || Debug.isFriend(DesignComponent.class, "<init>") || Debug.isFriend(DesignDocument.class, "updateDescriptorReferencesCore"));
        if (this.componentDescriptor == componentDescriptor) {
            return;
        }
        this.componentDescriptor = componentDescriptor;
        if (componentDescriptor != null) {
            for (PropertyDescriptor propertyDescriptor : componentDescriptor.getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                PropertyValue propertyValue = this.properties.get(propertyName);
                if (propertyValue != null && propertyValue.isCompatible(propertyDescriptor.getType())) continue;
                propertyValue = propertyDescriptor.createDefaultValue(this, propertyName);
                if (!propertyValue.isCompatible(propertyDescriptor)) {
                    Debug.warning("Default property value is not compatible", this.componentID, propertyName, propertyValue);
                }
                this.defaultProperties.put(propertyName, propertyValue);
                if (this.properties.get(propertyName) != null) {
                    this.writeProperty(propertyName, propertyValue);
                    continue;
                }
                this.properties.put(propertyName, propertyValue);
            }
            Collection presentersToRemove = this.presenters.lookupAll(Presenter.class);
            ArrayList<Presenter> temp = new ArrayList<Presenter>();
            this.gatherPresenters(temp, componentDescriptor);
            PresentersProcessor.postProcessDescriptor(this.document.getDocumentInterface().getProjectType(), this.document, componentDescriptor, temp);
            this.presenters = Lookups.fixed((Object[])temp.toArray());
            this.document.getTransactionManager().componentDescriptorChangeHappened(this, presentersToRemove, temp, useUndo);
        } else {
            this.document.getTransactionManager().componentDescriptorChangeHappened(this, null, null, useUndo);
        }
    }

    private void gatherPresenters(ArrayList<Presenter> tempPresenters, ComponentDescriptor componentDescriptor) {
        if (componentDescriptor == null) {
            return;
        }
        this.gatherPresenters(tempPresenters, componentDescriptor.getSuperDescriptor());
        componentDescriptor.gatherPresenters(tempPresenters);
    }

    public DesignDocument getDocument() {
        return this.document;
    }

    public long getComponentID() {
        return this.componentID;
    }

    public TypeID getType() {
        return this.type;
    }

    public DesignComponent getParentComponent() {
        assert (this.document.getTransactionManager().isAccess());
        return this.parentComponent;
    }

    public void addComponent(DesignComponent component) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (this.document == component.document);
        assert (component.parentComponent == null);
        assert (this.addComponentAssert(component));
        this.children.add(component);
        component.parentComponent = this;
        this.document.getTransactionManager().parentChangeHappened(null, this, component);
    }

    private boolean addComponentAssert(DesignComponent component) {
        for (DesignComponent parent = this; parent != null; parent = parent.getParentComponent()) {
            assert (parent != component);
        }
        return true;
    }

    public void removeComponent(DesignComponent component) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (this.document == component.document);
        assert (component.parentComponent == this);
        if (!this.children.remove(component)) {
            throw Debug.error("Component is not a child of its parent", "parent", this, "Child", component, "Children", this.children);
        }
        component.parentComponent = null;
        this.document.getTransactionManager().parentChangeHappened(this, null, component);
    }

    public void removeFromParentComponent() {
        assert (this.document.getTransactionManager().isWriteAccess());
        if (this.parentComponent != null) {
            this.parentComponent.removeComponent(this);
        }
    }

    public Collection<DesignComponent> getComponents() {
        assert (this.document.getTransactionManager().isAccess());
        return Collections.unmodifiableCollection(this.children);
    }

    public PropertyValue readProperty(String propertyName) {
        assert (this.document.getTransactionManager().isAccess());
        PropertyValue value = this.properties.get(propertyName);
        assert (this.properties.containsKey(propertyName)) : this.toString() + "." + propertyName + " property is missing";
        assert (value != null);
        return value;
    }

    public void writeProperty(String propertyName, PropertyValue propertyValue) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (propertyValue != null) : "Null property value";
        assert (this.componentDescriptor != null);
        PropertyValue oldValue = this.properties.get(propertyName);
        assert (oldValue != null) : "Missing old value in " + this + "." + propertyName;
        if (oldValue == propertyValue) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.componentDescriptor.getPropertyDescriptor(propertyName);
        assert (propertyDescriptor != null) : "Missing property descriptor in " + this + "." + propertyName;
        assert (!propertyDescriptor.isReadOnly()) : "Cannot write read-only property " + this + "." + propertyName;
        assert (propertyValue.isCompatible(propertyDescriptor));
        this.properties.put(propertyName, propertyValue);
        this.document.getTransactionManager().writePropertyHappened(this, propertyName, oldValue, propertyValue);
    }

    public boolean isDefaultValue(String propertyName) {
        assert (this.document.getTransactionManager().isAccess());
        assert (propertyName != null);
        PropertyValue defaultValue = this.defaultProperties.get(propertyName);
        PropertyValue currentValue = this.properties.get(propertyName);
        assert (defaultValue != null);
        assert (currentValue != null);
        return defaultValue == currentValue;
    }

    public void resetToDefault(String propertyName) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (propertyName != null);
        PropertyValue defaultValue = this.defaultProperties.get(propertyName);
        assert (defaultValue != null);
        this.writeProperty(propertyName, defaultValue);
    }

    PropertyValue getReferenceValue() {
        return this.referencePropertyValue;
    }

    public <T extends Presenter> T getPresenter(Class<T> presenterClass) {
        assert (this.document.getTransactionManager().isAccess());
        assert (presenterClass != null);
        return (T)((Presenter)this.presenters.lookup(presenterClass));
    }

    public <T> Collection<? extends T> getPresenters(Class<T> presenterClass) {
        assert (this.document.getTransactionManager().isAccess());
        assert (presenterClass != null);
        return this.presenters.lookupAll(presenterClass);
    }

    public String toString() {
        return this.componentID + ":" + this.type;
    }

    void dumpComponent(String indent) {
        assert (this.document.getTransactionManager().isAccess());
        System.out.println(indent + this.componentID + " : " + this.componentDescriptor);
        indent = indent + "    ";
        HashSet<String> undefinedProperties = new HashSet<String>(this.properties.keySet());
        Collection<PropertyDescriptor> propertyDescriptors = this.componentDescriptor.getPropertyDescriptors();
        for (PropertyDescriptor property : propertyDescriptors) {
            String name = property.getName();
            System.out.println(indent + (this.properties.get(name) == this.defaultProperties.get(name) ? "## " : ":: ") + name + " = " + this.properties.get(name));
            undefinedProperties.remove(name);
        }
        for (String name : undefinedProperties) {
            System.out.println(indent + "?? " + name + " = " + this.properties.get(name));
        }
        for (Object presenter : this.presenters.lookupAll(Object.class)) {
            System.out.println(indent + ">>" + presenter);
        }
        for (DesignComponent child : this.children) {
            child.dumpComponent(indent);
        }
    }
}

