/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.model.PresenterListener;

public abstract class DynamicPresenter
extends Presenter {
    private Listener listener;
    private State state = State.DISABLED;

    protected DynamicPresenter() {
    }

    final PresenterListener getPresenterListener() {
        return this.listener;
    }

    @Override
    final void setNotifyAttached(DesignComponent component) {
        super.setNotifyAttached(component);
        this.state = State.ADDING_DEPENDENCIES;
        this.notifyAttached(component);
        this.state = State.DISABLED;
        DesignEventFilter filter = this.getEventFilter();
        if (filter != null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            component.getDocument().getListenerManager().addDesignListener(this.listener, filter);
        }
    }

    @Override
    final void setNotifyDetached(DesignComponent component) {
        super.setNotifyDetached(component);
        if (this.listener != null) {
            component.getDocument().getListenerManager().removeDesignListener(this.listener);
        }
        this.state = State.REMOVING_DEPENDENCIES;
        this.notifyDetached(component);
        this.state = State.DISABLED;
    }

    protected abstract void notifyAttached(DesignComponent var1);

    protected abstract void notifyDetached(DesignComponent var1);

    protected abstract DesignEventFilter getEventFilter();

    protected abstract void designChanged(DesignEvent var1);

    protected abstract void presenterChanged(PresenterEvent var1);

    protected final void firePresenterChanged() {
        DesignComponent component = this.getComponent();
        assert (component != null);
        DesignDocument document = component.getDocument();
        assert (document != null);
        assert (document.getTransactionManager().isWriteAccess());
        assert (this.state == State.FIRING_PRESENTER_CHANGED);
        document.getListenerManager().firePresenterChanged(this);
    }

    protected final void addDependency(DesignComponent component, Class<? extends Presenter> presenterClass) {
        assert (this.state == State.ADDING_DEPENDENCIES);
        if (this.listener == null) {
            this.listener = new Listener();
        }
        component.getDocument().getListenerManager().addPresenterListener(component, presenterClass, this.listener);
    }

    protected final void removeDependency(DesignComponent component, Class<? extends Presenter> presenterClass) {
        assert (this.state == State.REMOVING_DEPENDENCIES);
        if (this.listener != null) {
            component.getDocument().getListenerManager().removePresenterListener(component, presenterClass, this.listener);
        }
    }

    private static enum State {
        DISABLED,
        FIRING_PRESENTER_CHANGED,
        ADDING_DEPENDENCIES,
        REMOVING_DEPENDENCIES;

    }

    private class Listener
    implements DesignListener,
    PresenterListener {
        private Listener() {
        }

        @Override
        public void designChanged(DesignEvent event) {
            DynamicPresenter.this.state = State.FIRING_PRESENTER_CHANGED;
            DynamicPresenter.this.designChanged(event);
            DynamicPresenter.this.state = State.DISABLED;
        }

        @Override
        public void presenterChanged(PresenterEvent event) {
            DynamicPresenter.this.state = State.FIRING_PRESENTER_CHANGED;
            DynamicPresenter.this.presenterChanged(event);
            DynamicPresenter.this.state = State.DISABLED;
        }

        public String toString() {
            return DynamicPresenter.this.toString();
        }
    }
}

