/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.ri.platform.installer.RIPlatformFactory;
import org.netbeans.modules.javacard.spi.JavacardPlatformKeyNames;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

abstract class PlatformValidator
implements Runnable {
    private final ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
    private final EditableProperties properties = new EditableProperties(true);
    private volatile boolean failed;
    protected final FileObject file;
    private volatile Exception failException;
    private boolean hasRun;
    private volatile boolean running = true;
    private boolean debugMode = !Utilities.isWindows();
    String failMessage;

    PlatformValidator(FileObject baseDir) {
        this.file = baseDir;
        Parameters.notNull((CharSequence)"File", (Object)this.file);
    }

    boolean isRunning() {
        return this.running;
    }

    final void start() {
        assert (EventQueue.isDispatchThread());
        if (this.hasRun) {
            throw new IllegalStateException(this + " run twice");
        }
        this.hasRun = true;
        this.onStart();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    final boolean hasRun() {
        return this.hasRun;
    }

    final boolean failed() {
        return this.failed;
    }

    String failMessage() {
        return this.failMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (!EventQueue.isDispatchThread()) {
            try {
                this.validatePlatform();
                this.running = false;
                this.onSucceed(this.getStandardOutput());
            }
            catch (Exception e) {
                Logger.getLogger(PlatformValidator.class.getName()).log(Level.INFO, "Could not validate JavaCard platform " + this.file.getPath(), e);
                this.failException = e;
                this.failed = true;
            }
            finally {
                EventQueue.invokeLater(this);
            }
        } else {
            try {
                if (this.failed) {
                    this.onFail(this.failException);
                }
            }
            finally {
                this.running = false;
                this.onDone();
            }
        }
    }

    protected final String getErrorOutput() {
        try {
            return this.stdErr.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            return this.stdErr.toString();
        }
    }

    protected final String getStandardOutput() {
        try {
            return this.stdOut.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            return this.stdOut.toString();
        }
    }

    protected final EditableProperties getPlatformProps() {
        return this.properties;
    }

    abstract void onStart();

    abstract void onFail(Exception var1);

    abstract void onSucceed(String var1);

    abstract void onDone();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePlatform() throws Exception {
        assert (!EventQueue.isDispatchThread());
        if (this.file == null) {
            String msg = NbBundle.getMessage(PlatformValidator.class, (String)"ERR_DOES_NOT_EXIST", (Object)this.file.getPath());
            throw new IOException(msg);
        }
        if (!this.file.isFolder()) {
            String msg = NbBundle.getMessage(PlatformValidator.class, (String)"ERR_NOT_A_FILE", (Object)this.file.getPath());
            throw new IOException(msg);
        }
        EditableProperties props = new EditableProperties(true);
        FileObject fo = this.file.getFileObject("platform.properties");
        BufferedInputStream in = new BufferedInputStream(fo.getInputStream());
        try {
            props.load((InputStream)in);
        }
        finally {
            ((InputStream)in).close();
        }
        File dir = FileUtil.toFile((FileObject)this.file);
        this.properties.putAll((Map)props);
        Set required = JavacardPlatformKeyNames.getRequiredProperties();
        String comma = NbBundle.getMessage(PlatformValidator.class, (String)"COMMA");
        if (!props.keySet().containsAll(required)) {
            StringBuilder sb = new StringBuilder();
            required.removeAll(props.keySet());
            for (String s : required) {
                if (sb.length() > 0) {
                    sb.append(comma);
                }
                sb.append(s);
            }
            throw new IOException(NbBundle.getMessage(PlatformValidator.class, (String)"ERR_MISSING_REQUIRED_PROPERTIES", (Object)fo.getPath(), (Object)sb));
        }
        if (!RIPlatformFactory.canInstall((Map<? extends Object, ? extends Object>)props)) {
            throw new IOException(NbBundle.getMessage(RIPlatformFactory.class, (String)"ERR_TOO_OLD", (Object)props.get((Object)"javacard.version"), (Object)RIPlatformFactory.MINIMUM_SUPPORTED_VERSION));
        }
        String path = props.getProperty("javacard.emulator");
        if (!this.debugMode && path != null) {
            path = RIPlatformFactory.translatePath(dir, path);
            String cmd = path + " -version";
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStream out = proc.getInputStream();
            InputStream err = proc.getErrorStream();
            RequestProcessor.getDefault().post((Runnable)new Copier(out, this.stdOut));
            RequestProcessor.getDefault().post((Runnable)new Copier(err, this.stdErr));
            if (proc.waitFor() > 0) {
                String s = this.stdOut.toString("UTF-8") + "\n" + this.stdErr.toString("UTF-8");
                throw new IOException(NbBundle.getMessage(PlatformValidator.class, (String)"MSG_EXECUTION_FAILED", (Object)s));
            }
        }
    }

    private static class Copier
    implements Runnable {
        InputStream in;
        OutputStream out;

        public Copier(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                FileUtil.copy((InputStream)this.in, (OutputStream)this.out);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

