/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NumericDisplayFilter
implements TableModelFilter,
NodeActionsProviderFilter,
Constants {
    private final Map<Variable, NumericDisplaySettings> variableToDisplaySettings = new HashMap<Variable, NumericDisplaySettings>();
    private HashSet listeners;

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if ((string == "WatchValue" || string == "WatchToString" || string == "LocalsValue" || string == "LocalsToString") && object instanceof Variable && this.isIntegralType((Variable)object)) {
            Variable variable = (Variable)object;
            NumericDisplaySettings numericDisplaySettings = this.variableToDisplaySettings.get(variable);
            if (numericDisplaySettings == null && variable instanceof Field) {
                Variable variable2 = null;
                try {
                    Method method = variable.getClass().getMethod("getParentVariable", new Class[0]);
                    method.setAccessible(true);
                    variable2 = (Variable)method.invoke((Object)variable, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                numericDisplaySettings = this.variableToDisplaySettings.get(variable2);
            }
            return this.getValue(variable, numericDisplaySettings);
        }
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        if ((string == "WatchValue" || string == "WatchToString" || string == "LocalsValue" || string == "LocalsToString") && object instanceof Variable && this.isIntegralType((Variable)object) && object2 instanceof String) {
            Variable variable = (Variable)object;
            object2 = this.setValue(variable, this.variableToDisplaySettings.get(variable), (String)object2);
        }
        tableModel.setValueAt(object, string, object2);
    }

    public void addModelListener(ModelListener modelListener) {
        HashSet hashSet = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        hashSet.add(modelListener);
        this.listeners = hashSet;
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            return;
        }
        HashSet hashSet = (HashSet)this.listeners.clone();
        hashSet.remove(modelListener);
        this.listeners = hashSet;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Variable variable;
        Action[] actionArray;
        if (!(object instanceof Variable)) {
            return nodeActionsProvider.getActions(object);
        }
        try {
            actionArray = nodeActionsProvider.getActions(object);
        }
        catch (UnknownTypeException unknownTypeException) {
            actionArray = new Action[]{};
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (object instanceof Variable && this.isIntegralTypeOrArray(variable = (Variable)object)) {
            arrayList.add(new DisplayAsAction((Variable)object));
        }
        arrayList.addAll(Arrays.asList(actionArray));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static int getChar(String string) {
        string = string.substring(1, string.length() - 1);
        char c = string.charAt(0);
        return c & 0xFFFF;
    }

    private Object getValue(Variable variable, NumericDisplaySettings numericDisplaySettings) {
        if (numericDisplaySettings == null) {
            return variable.getValue();
        }
        String string = variable.getType();
        try {
            switch (numericDisplaySettings) {
                case DECIMAL: {
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return Integer.toString(n);
                    }
                    return variable.getValue();
                }
                case HEXADECIMAL: {
                    if ("int".equals(string)) {
                        return "0x" + Integer.toHexString(Integer.parseInt(variable.getValue()));
                    }
                    if ("short".equals(string)) {
                        String string2 = Integer.toHexString(Short.parseShort(variable.getValue()));
                        if (string2.length() > 4) {
                            string2 = string2.substring(string2.length() - 4, string2.length());
                        }
                        return "0x" + string2;
                    }
                    if ("byte".equals(string)) {
                        String string3 = Integer.toHexString(Byte.parseByte(variable.getValue()));
                        if (string3.length() > 2) {
                            string3 = string3.substring(string3.length() - 2, string3.length());
                        }
                        return "0x" + string3;
                    }
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return "0x" + Integer.toHexString(n);
                    }
                    return "0x" + Long.toHexString(Long.parseLong(variable.getValue()));
                }
                case OCTAL: {
                    if ("int".equals(string)) {
                        return "0" + Integer.toOctalString(Integer.parseInt(variable.getValue()));
                    }
                    if ("short".equals(string)) {
                        String string4 = Integer.toOctalString(Short.parseShort(variable.getValue()));
                        if (string4.length() > 5) {
                            string4 = string4.substring(string4.length() - 5, string4.length());
                        }
                        return "0" + (string4.charAt(0) == '0' ? "1" : "") + string4;
                    }
                    if ("byte".equals(string)) {
                        String string5 = Integer.toOctalString(Byte.parseByte(variable.getValue()));
                        if (string5.length() > 3) {
                            string5 = "1" + string5.substring(string5.length() - 2, string5.length());
                        }
                        return "0" + string5;
                    }
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return "0" + Integer.toOctalString(n);
                    }
                    return "0" + Long.toOctalString(Long.parseLong(variable.getValue()));
                }
                case BINARY: {
                    if ("int".equals(string)) {
                        return Integer.toBinaryString(Integer.parseInt(variable.getValue()));
                    }
                    if ("short".equals(string)) {
                        String string6 = Integer.toBinaryString(Short.parseShort(variable.getValue()));
                        if (string6.length() > 16) {
                            string6 = string6.substring(string6.length() - 16, string6.length());
                        }
                        return string6;
                    }
                    if ("byte".equals(string)) {
                        String string7 = Integer.toBinaryString(Byte.parseByte(variable.getValue()));
                        if (string7.length() > 8) {
                            string7 = string7.substring(string7.length() - 8, string7.length());
                        }
                        return string7;
                    }
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return Integer.toBinaryString(n);
                    }
                    return Long.toBinaryString(Long.parseLong(variable.getValue()));
                }
                case CHAR: {
                    if ("char".equals(string)) {
                        return variable.getValue();
                    }
                    return "'" + new Character((char)Integer.parseInt(variable.getValue())) + "'";
                }
                case TIME: {
                    if (!"long".equals(string)) break;
                    return new Date(Long.parseLong(variable.getValue())).toString();
                }
            }
            return variable.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            return numberFormatException.getLocalizedMessage();
        }
    }

    private Object setValue(Variable variable, NumericDisplaySettings numericDisplaySettings, String string) {
        if (numericDisplaySettings == null) {
            return string;
        }
        String string2 = variable.getType();
        try {
            switch (numericDisplaySettings) {
                case BINARY: {
                    if ("int".equals(string2)) {
                        return Integer.toString(Integer.parseInt(string, 2));
                    }
                    if ("short".equals(string2)) {
                        return Short.toString(Short.parseShort(string, 2));
                    }
                    if ("byte".equals(string2)) {
                        return Byte.toString(Byte.parseByte(string, 2));
                    }
                    if ("char".equals(string2)) {
                        return "'" + Character.toString((char)Integer.parseInt(string, 2)) + "'";
                    }
                    return Long.toString(Long.parseLong(string, 2)) + "l";
                }
            }
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            return numberFormatException.getLocalizedMessage();
        }
    }

    private boolean isIntegralType(Variable variable) {
        if (!VariablesTreeModelFilter.isEvaluated(variable)) {
            return false;
        }
        String string = variable.getType();
        return "int".equals(string) || "char".equals(string) || "byte".equals(string) || "long".equals(string) || "short".equals(string);
    }

    private boolean isIntegralTypeOrArray(Variable variable) {
        if (!VariablesTreeModelFilter.isEvaluated(variable)) {
            return false;
        }
        String string = NumericDisplayFilter.removeArray(variable.getType());
        return "int".equals(string) || "char".equals(string) || "byte".equals(string) || "long".equals(string) || "short".equals(string);
    }

    private static String removeArray(String string) {
        if (string.length() > 0 && string.endsWith("[]")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    private class DisplayAsAction
    extends AbstractAction
    implements Presenter.Popup {
        private Variable variable;
        private String type;

        public DisplayAsAction(Variable variable) {
            this.variable = variable;
            this.type = NumericDisplayFilter.removeArray(variable.getType());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(NbBundle.getMessage(NumericDisplayFilter.class, (String)"CTL_Variable_DisplayAs_Popup"));
            DisplayAsMenuItem displayAsMenuItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Decimal", NumericDisplaySettings.DECIMAL);
            DisplayAsMenuItem displayAsMenuItem2 = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Hexadecimal", NumericDisplaySettings.HEXADECIMAL);
            DisplayAsMenuItem displayAsMenuItem3 = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Octal", NumericDisplaySettings.OCTAL);
            DisplayAsMenuItem displayAsMenuItem4 = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Binary", NumericDisplaySettings.BINARY);
            DisplayAsMenuItem displayAsMenuItem5 = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Character", NumericDisplaySettings.CHAR);
            DisplayAsMenuItem displayAsMenuItem6 = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Time", NumericDisplaySettings.TIME);
            NumericDisplaySettings numericDisplaySettings = (NumericDisplaySettings)((Object)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable));
            if (numericDisplaySettings != null) {
                switch (numericDisplaySettings) {
                    case DECIMAL: {
                        displayAsMenuItem.setSelected(true);
                        break;
                    }
                    case HEXADECIMAL: {
                        displayAsMenuItem2.setSelected(true);
                        break;
                    }
                    case OCTAL: {
                        displayAsMenuItem3.setSelected(true);
                        break;
                    }
                    case BINARY: {
                        displayAsMenuItem4.setSelected(true);
                        break;
                    }
                    case CHAR: {
                        displayAsMenuItem5.setSelected(true);
                        break;
                    }
                    case TIME: {
                        displayAsMenuItem6.setSelected(true);
                    }
                }
            } else if ("char".equals(this.type)) {
                displayAsMenuItem5.setSelected(true);
            } else {
                displayAsMenuItem.setSelected(true);
            }
            jMenu.add(displayAsMenuItem);
            jMenu.add(displayAsMenuItem2);
            jMenu.add(displayAsMenuItem3);
            jMenu.add(displayAsMenuItem4);
            jMenu.add(displayAsMenuItem5);
            if ("long".equals(this.type)) {
                jMenu.add(displayAsMenuItem6);
            }
            return jMenu;
        }

        private void onDisplayAs(NumericDisplaySettings numericDisplaySettings) {
            NumericDisplaySettings numericDisplaySettings2 = (NumericDisplaySettings)((Object)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable));
            if (numericDisplaySettings2 == null) {
                numericDisplaySettings2 = "char".equals(this.type) ? NumericDisplaySettings.CHAR : NumericDisplaySettings.DECIMAL;
            }
            if (numericDisplaySettings2 == numericDisplaySettings) {
                return;
            }
            NumericDisplayFilter.this.variableToDisplaySettings.put(this.variable, numericDisplaySettings);
            this.fireModelChanged();
        }

        private void fireModelChanged() {
            if (NumericDisplayFilter.this.listeners == null) {
                return;
            }
            ModelEvent.TableValueChanged tableValueChanged = new ModelEvent.TableValueChanged((Object)this, (Object)this.variable, null);
            for (ModelListener modelListener : NumericDisplayFilter.this.listeners) {
                modelListener.modelChanged((ModelEvent)tableValueChanged);
            }
        }

        private class DisplayAsMenuItem
        extends JRadioButtonMenuItem {
            public DisplayAsMenuItem(String string, final NumericDisplaySettings numericDisplaySettings) {
                super(new AbstractAction(NbBundle.getMessage(NumericDisplayFilter.class, (String)string)){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DisplayAsAction.this.onDisplayAs(numericDisplaySettings);
                    }
                });
            }
        }
    }

    static enum NumericDisplaySettings {
        DECIMAL,
        HEXADECIMAL,
        OCTAL,
        BINARY,
        CHAR,
        TIME;

    }
}

