/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private Map<File, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private int completedSearches;
    private boolean searchCanceled;

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        this.criteria = master.getCriteria();
        this.pathToRoot = new HashMap<String, File>();
        this.workFiles = new HashMap<File, Set<File>>();
        for (File file : master.getRoots()) {
            File root = Mercurial.getInstance().getRepositoryRoot(file);
            Set<File> set = this.workFiles.get(root);
            if (set == null) {
                set = new HashSet<File>(2);
                this.workFiles.put(root, set);
            }
            set.add(file);
        }
    }

    @Override
    public void run() {
        final String fromRevision = this.criteria.getFrom();
        final String toRevision = this.criteria.getTo();
        final int limitRevisions = this.criteria.getLimit();
        this.completedSearches = 0;
        for (Map.Entry<File, Set<File>> entry : this.workFiles.entrySet()) {
            final File root = entry.getKey();
            final Set<File> files = entry.getValue();
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
            HgProgressSupport support = new HgProgressSupport(){

                @Override
                public void perform() {
                    OutputLogger logger = this.getLogger();
                    SearchExecutor.this.search(root, files, fromRevision, toRevision, limitRevisions, this, logger);
                }
            };
            support.start(rp, root, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
        }
    }

    private void search(File root, Set<File> files, String fromRevision, String toRevision, int limitRevisions, HgProgressSupport progressSupport, OutputLogger logger) {
        if (progressSupport.isCanceled()) {
            this.searchCanceled = true;
            return;
        }
        HgLogMessage[] messages = this.master.isIncomingSearch() ? HgCommand.getIncomingMessages(root, toRevision, this.master.isShowMerges(), logger) : (this.master.isOutSearch() ? HgCommand.getOutMessages(root, toRevision, this.master.isShowMerges(), logger) : (!this.master.isShowInfo() ? HgCommand.getLogMessagesNoFileInfo(root, files, fromRevision, toRevision, this.master.isShowMerges(), limitRevisions, logger) : HgCommand.getLogMessages(root, files, fromRevision, toRevision, this.master.isShowMerges(), true, limitRevisions, logger, true)));
        this.appendResults(root, messages);
    }

    private synchronized void appendResults(File root, HgLogMessage[] logMessages) {
        HashMap<String, String> historyPaths = new HashMap<String, String>();
        ArrayList<RepositoryRevision> results = new ArrayList<RepositoryRevision>();
        for (int i = logMessages.length - 1; i >= 0; --i) {
            String msg;
            HgLogMessage logMessage = logMessages[i];
            String username = this.criteria.getUsername();
            if (username != null && logMessage.getAuthor().indexOf(username) == -1 || (msg = this.criteria.getCommitMessage()) != null && logMessage.getMessage().indexOf(msg) == -1) continue;
            RepositoryRevision rev = new RepositoryRevision(logMessage, root);
            for (RepositoryRevision.Event event : rev.getEvents()) {
                if (event.getChangedPath().getAction() == 'A' && event.getChangedPath().getCopySrcPath() != null) {
                    String existingMapping = (String)historyPaths.get(event.getChangedPath().getPath());
                    if (existingMapping == null) {
                        existingMapping = event.getChangedPath().getPath();
                    }
                    historyPaths.put(event.getChangedPath().getCopySrcPath(), existingMapping);
                }
                String originalFilePath = event.getChangedPath().getPath();
                for (String srcPath : historyPaths.keySet()) {
                    if (!originalFilePath.startsWith(srcPath) || originalFilePath.length() != srcPath.length() && originalFilePath.charAt(srcPath.length()) != '/') continue;
                    originalFilePath = (String)historyPaths.get(srcPath) + originalFilePath.substring(srcPath.length());
                    break;
                }
                File file = new File(root, originalFilePath);
                event.setFile(file);
            }
            results.add(rev);
        }
        this.checkFinished(results);
    }

    private void checkFinished(final List<RepositoryRevision> results) {
        ++this.completedSearches;
        if (this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (results.isEmpty()) {
                        SearchExecutor.this.master.setResults(null);
                    } else {
                        SearchExecutor.this.master.setResults(results);
                    }
                }
            });
        }
    }
}

