/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.config.HgConfigFiles;

public class HgRepositoryContextCache {
    private Map<File, DefaultPaths> rootToDefaultPaths;
    private static HgRepositoryContextCache instance;

    private HgRepositoryContextCache() {
    }

    public static HgRepositoryContextCache getInstance() {
        if (instance == null) {
            instance = new HgRepositoryContextCache();
        }
        return instance;
    }

    public synchronized void reset() {
        this.getRootToDefaultPaths().clear();
    }

    public synchronized String getPullDefault(File file) {
        File repoRoot = Mercurial.getInstance().getRepositoryRoot(file);
        if (repoRoot == null) {
            return null;
        }
        DefaultPaths paths = this.getDefaultPaths(repoRoot);
        return paths.pull;
    }

    public synchronized String getPushDefault(File file) {
        File repoRoot = Mercurial.getInstance().getRepositoryRoot(file);
        if (repoRoot == null) {
            return null;
        }
        DefaultPaths paths = this.getDefaultPaths(repoRoot);
        return paths.push;
    }

    private DefaultPaths getDefaultPaths(File repoRoot) {
        Map<File, DefaultPaths> map = this.getRootToDefaultPaths();
        DefaultPaths paths = map.get(repoRoot);
        if (paths == null) {
            HgConfigFiles config = new HgConfigFiles(repoRoot);
            String pull = config.getDefaultPull(true);
            String push = config.getDefaultPush(true);
            paths = new DefaultPaths(pull, push);
            map.put(repoRoot, paths);
        }
        return paths;
    }

    private Map<File, DefaultPaths> getRootToDefaultPaths() {
        if (this.rootToDefaultPaths == null) {
            this.rootToDefaultPaths = new HashMap<File, DefaultPaths>();
        }
        return this.rootToDefaultPaths;
    }

    private static class DefaultPaths {
        String pull;
        String push;

        public DefaultPaths(String pull, String push) {
            this.pull = pull;
            this.push = push;
        }
    }
}

