/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Element;

public class ArchiveProjectProperties {
    private Project project;
    private AntProjectHelper helper;
    private EditableProperties projectProps;
    private EditableProperties privateProps;
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String SOURCE_ARCHIVE = "source.archive";
    public static final String DIST_DIR = "dist.dir";
    public static final String WAR_NAME = "war.name";
    public static final String PROXY_PROJECT_DIR = "proxy.project.dir";
    public static final String TMP_PROJ_DIR_VALUE = "tmpproj";
    public static final String DIST_DIR_VALUE = "dist";
    public static final String DIST_ARCHIVE = "dist.archive";
    public static final String CONTENT_DIR = "content.dir";
    public static final String CONF_DIR = "conf.dir";
    public static final String SETUP_DIR_VALUE = "setup";
    public static final String ARCHIVE_TYPE = "javaee.archive.type";
    public static final String PROJECT_TYPE_VALUE_UNKNOWN = "unknown";
    public static final String PROJECT_TYPE_VALUE_WAR = "war";
    public static final String PROJECT_TYPE_VALUE_EAR = "ear";
    public static final String PROJECT_TYPE_VALUE_CAR = "car";
    public static final String PROJECT_TYPE_VALUE_RAR = "rar";
    public static final String PROJECT_TYPE_VALUE_JAR = "jar";
    public static final String WAR_ARCHIVES = "javaee.archive.war.archives";
    public static final String JAR_ARCHIVES = "javaee.archive.jar.archives";
    public static final String RAR_ARCHIVES = "javaee.archive.rar.archives";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    public static final String CAR_ARCHIVES = "javaee.archive.car.archives";

    public ArchiveProjectProperties(Project project, AntProjectHelper antProjectHelper) {
        this.project = project;
        this.helper = antProjectHelper;
        this.privateProps = antProjectHelper.getProperties("nbproject/private/private.properties");
        this.projectProps = antProjectHelper.getProperties("nbproject/project.properties");
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    try {
                        ArchiveProjectProperties.this.helper.putProperties("nbproject/project.properties", ArchiveProjectProperties.this.projectProps);
                        ArchiveProjectProperties.this.helper.putProperties("nbproject/private/private.properties", ArchiveProjectProperties.this.privateProps);
                        Element element = ArchiveProjectProperties.this.helper.getPrimaryConfigurationData(true);
                        ArchiveProjectProperties.this.helper.putPrimaryConfigurationData(element, true);
                        ProjectManager.getDefault().saveProject(ArchiveProjectProperties.this.project);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)mutexException.getException());
        }
    }

    public Object get(String string) {
        String string2 = J2EE_SERVER_INSTANCE.equals(string) ? this.privateProps.getProperty(J2EE_SERVER_INSTANCE) : this.projectProps.getProperty(string);
        return string2;
    }

    public void put(String string, String string2) {
        if (J2EE_SERVER_INSTANCE.equals(string)) {
            try {
                this.projectProps.put(J2EE_SERVER_TYPE, Deployment.getDefault().getServerInstance(string2).getServerID());
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger("global").log(Level.INFO, string2, instanceRemovedException);
            }
            this.privateProps.put(J2EE_SERVER_INSTANCE, string2);
        } else {
            this.projectProps.put(string, string2);
        }
    }

    public static void setServerInstance(final Project project, final AntProjectHelper antProjectHelper, final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
                    ArchiveProjectProperties.setNewServerInstanceValue(string, editableProperties, editableProperties2);
                    File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                    try {
                        AntDeploymentHelper.writeDeploymentScript((File)new File(file, ArchiveProjectProperties.ANT_DEPLOY_BUILD_SCRIPT), (Object)ArchiveProjectProperties.mapType(editableProperties.getProperty(ArchiveProjectProperties.ARCHIVE_TYPE)), (String)string);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    File file2 = AntDeploymentHelper.getDeploymentPropertiesFile((String)string);
                    if (file2 == null) {
                        editableProperties2.remove((Object)ArchiveProjectProperties.DEPLOY_ANT_PROPS_FILE);
                    } else {
                        editableProperties2.setProperty(ArchiveProjectProperties.DEPLOY_ANT_PROPS_FILE, file2.getAbsolutePath());
                    }
                    antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    private static void setNewServerInstanceValue(String string, EditableProperties editableProperties, EditableProperties editableProperties2) {
        try {
            editableProperties.put(J2EE_SERVER_TYPE, Deployment.getDefault().getServerInstance(string).getServerID());
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Logger.getLogger("global").log(Level.INFO, string, instanceRemovedException);
        }
        editableProperties2.setProperty(J2EE_SERVER_INSTANCE, string);
    }

    public static Object mapType(String string) {
        J2eeModule.Type type = J2eeModule.Type.EJB;
        if (string.equals(PROJECT_TYPE_VALUE_CAR)) {
            type = J2eeModule.Type.CAR;
        }
        if (string.equals(PROJECT_TYPE_VALUE_WAR)) {
            type = J2eeModule.Type.WAR;
        }
        if (string.equals(PROJECT_TYPE_VALUE_JAR)) {
            type = J2eeModule.Type.EJB;
        }
        if (string.equals(PROJECT_TYPE_VALUE_EAR)) {
            type = J2eeModule.Type.EAR;
        }
        if (string.equals(PROJECT_TYPE_VALUE_RAR)) {
            type = J2eeModule.Type.RAR;
        }
        return type;
    }
}

