/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;

public abstract class JAXRCommand {
    RegistryServiceImpl service;
    UDDIMapper mapper;
    BulkResponseImpl response;
    BulkResponseImpl content;

    public JAXRCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl) throws JAXRException {
        this.service = registryServiceImpl;
        this.response = bulkResponseImpl;
        this.mapper = new UDDIMapper(registryServiceImpl);
    }

    abstract void execute() throws JAXRException;

    static class SaveServicesCommand
    extends JAXRCommand {
        Collection services;

        public SaveServicesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.services = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveServices(this.services));
        }
    }

    static class SaveServiceBindingsCommand
    extends JAXRCommand {
        Collection bindings;

        public SaveServiceBindingsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.bindings = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveServiceBindings(this.bindings));
        }
    }

    static class SaveOrganizationsCommand
    extends JAXRCommand {
        Collection organizations;

        public SaveOrganizationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.organizations = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveOrganizations(this.organizations));
        }
    }

    static class SaveObjectsCommand
    extends JAXRCommand {
        Collection cataloguedObjects;

        public SaveObjectsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.cataloguedObjects = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveObjects(this.cataloguedObjects));
        }
    }

    static class SaveConceptsCommand
    extends JAXRCommand {
        Collection concepts;

        public SaveConceptsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.concepts = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveConcepts(this.concepts));
        }
    }

    static class SaveClassificationSchemesCommand
    extends JAXRCommand {
        Collection schemes;

        public SaveClassificationSchemesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.schemes = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveClassificationSchemes(this.schemes));
        }
    }

    static class SaveAssociationsCommand
    extends JAXRCommand {
        Collection associations;
        boolean replace;

        public SaveAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, boolean bl) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.associations = collection;
            this.replace = bl;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveAssociations(this.associations, this.replace));
        }
    }

    static class GetRegistryObjectsByTypeCommand
    extends JAXRCommand {
        String objectType;

        public GetRegistryObjectsByTypeCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, String string2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.objectType = string2;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects(this.objectType));
        }
    }

    static class GetRegistryObjectsByKeysCommand
    extends JAXRCommand {
        Collection objectKeys;
        String type;

        public GetRegistryObjectsByKeysCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, String string2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.objectKeys = collection;
            this.type = string2;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects(this.objectKeys, this.type));
        }
    }

    static class FindCallerAssociationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Boolean confirmedByCaller;
        Boolean confirmedByOther;
        Collection associationTypes;

        public FindCallerAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Boolean bl, Boolean bl2, Collection collection2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.confirmedByCaller = bl;
            this.confirmedByOther = bl2;
            this.associationTypes = collection2;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findCallerAssociations(this.findQualifiers, this.confirmedByCaller, this.confirmedByOther, this.associationTypes));
        }
    }

    static class FindAssociationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        String sourceObjectId;
        String targetObjectId;
        Collection associationTypes;

        public FindAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, String string2, String string3, Collection collection2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.sourceObjectId = string2;
            this.targetObjectId = string3;
            this.associationTypes = collection2;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findAssociations(this.findQualifiers, this.sourceObjectId, this.targetObjectId, this.associationTypes));
        }
    }

    static class FindServicesCommand
    extends JAXRCommand {
        Key orgKey;
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection specifications;

        public FindServicesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Key key, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.orgKey = key;
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.specifications = collection4;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findServices(this.orgKey, this.findQualifiers, this.namePatterns, this.classifications, this.specifications));
        }
    }

    static class FindServiceBindingsCommand
    extends JAXRCommand {
        Key serviceKey;
        Collection findQualifiers;
        Collection classifications;
        Collection specifications;

        public FindServiceBindingsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Key key, Collection collection, Collection collection2, Collection collection3) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.serviceKey = key;
            this.findQualifiers = collection;
            this.classifications = collection2;
            this.specifications = collection3;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findServiceBindings(this.serviceKey, this.findQualifiers, this.classifications, this.specifications));
        }
    }

    static class FindOrganizationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection specifications;
        Collection identifiers;
        Collection externalLinks;

        public FindOrganizationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.specifications = collection4;
            this.identifiers = collection5;
            this.externalLinks = collection6;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findOrganizations(this.findQualifiers, this.namePatterns, this.classifications, this.specifications, this.identifiers, this.externalLinks));
        }
    }

    static class FindConceptsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection identifiers;
        Collection externalLinks;

        public FindConceptsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.identifiers = collection4;
            this.externalLinks = collection5;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findConcepts(this.findQualifiers, this.namePatterns, this.classifications, this.identifiers, this.externalLinks));
        }
    }

    static class FindClassificationSchemesCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection externalLinks;

        public FindClassificationSchemesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.externalLinks = collection4;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findClassificationSchemes(this.findQualifiers, this.namePatterns, this.classifications, this.externalLinks));
        }
    }

    static class DeleteServicesCommand
    extends JAXRCommand {
        Collection serviceKeys;

        public DeleteServicesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.serviceKeys = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteServices(this.serviceKeys));
        }
    }

    static class DeleteServiceBindingsCommand
    extends JAXRCommand {
        Collection bindingKeys;

        public DeleteServiceBindingsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.bindingKeys = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteServiceBindings(this.bindingKeys));
        }
    }

    static class DeleteOrganizationsCommand
    extends JAXRCommand {
        Collection organizationKeys;

        public DeleteOrganizationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.organizationKeys = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteOrganizations(this.organizationKeys));
        }
    }

    static class DeleteObjectsCommand
    extends JAXRCommand {
        Collection keys;
        String type;

        public DeleteObjectsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, String string2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.keys = collection;
            this.type = string2;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteObjects(this.keys, this.type));
        }
    }

    static class DeleteConceptsCommand
    extends JAXRCommand {
        Collection conceptKeys;

        public DeleteConceptsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.conceptKeys = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteConcepts(this.conceptKeys));
        }
    }

    static class DeleteClassificationSchemesCommand
    extends JAXRCommand {
        Collection schemeKeys;

        public DeleteClassificationSchemesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.schemeKeys = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteConcepts(this.schemeKeys));
        }
    }

    static class DeleteAssociationsCommand
    extends JAXRCommand {
        Collection schemeKeys;

        public DeleteAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.schemeKeys = collection;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteAssociations(this.schemeKeys));
        }
    }

    static class GetRegistryObjectsCommand
    extends JAXRCommand {
        public GetRegistryObjectsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects());
        }
    }
}

