/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceModelBuilder;
import org.netbeans.modules.websvc.rest.codegen.model.RuntimeJpaEntity;
import org.netbeans.modules.websvc.rest.support.MetadataModelReadHelper;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.EntitySelectionPanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EntitySelectionPanelVisual
extends JPanel
implements AbstractPanel.Settings {
    private static final int MAX_RETRY = 10;
    private Project project;
    private List<ChangeListener> listeners;
    private String persistenceUnit;
    MetadataModelReadHelper<EntityMappingsMetadata, EntityMappings> entitiesHelper;
    private EntityMappings mappings;
    private EntityResourceModelBuilder builder;
    private EntityResourceBeanModel resourceModel;
    private EntityListModel availableModel;
    private EntityListModel selectedModel;
    private int retryCount = 0;
    private JButton buttonAdd;
    private JButton buttonAddAll;
    private JButton buttonRemove;
    private JButton buttonRemoveAll;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelAvailableEntities;
    private JLabel labelSelectedEntities;
    private JList listAvailable;
    private JList listSelected;
    private JPanel panelButtons;
    private final ListCellRenderer ENTITY_LIST_RENDERER = new EntityListCellRenderer();
    private static final String MSG_RETRIEVING = NbBundle.getMessage(EntitySelectionPanel.class, (String)"MSG_Retrieving");

    public EntitySelectionPanelVisual(String string) {
        this.setName(string);
        this.listeners = new ArrayList<ChangeListener>();
        this.initComponents();
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EntitySelectionPanelVisual.this.updateButtons();
            }
        };
        this.listAvailable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.listSelected.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JList();
        this.labelAvailableEntities = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.buttonAddAll = new JButton();
        this.buttonRemoveAll = new JButton();
        this.labelSelectedEntities = new JLabel();
        this.listAvailable.setCellRenderer(this.ENTITY_LIST_RENDERER);
        this.jScrollPane1.setViewportView(this.listAvailable);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/rest/wizard/Bundle");
        this.listAvailable.getAccessibleContext().setAccessibleName(resourceBundle.getString("AvailableEntityClasses"));
        this.listAvailable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DESC_AvailableEntityClasses"));
        this.listSelected.setCellRenderer(this.ENTITY_LIST_RENDERER);
        this.listSelected.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EntitySelectionPanelVisual.this.listSelectedValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.listSelected);
        this.listSelected.getAccessibleContext().setAccessibleName(resourceBundle.getString("SelectedEntityList"));
        this.listSelected.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DESC_SelectedEntityClasses"));
        this.labelAvailableEntities.setLabelFor(this.listAvailable);
        Mnemonics.setLocalizedText((JLabel)this.labelAvailableEntities, (String)resourceBundle.getString("LBL_AvailableEntities"));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAdd, (String)NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"LBL_Add"));
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitySelectionPanelVisual.this.addActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemove, (String)NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"LBL_Remove"));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitySelectionPanelVisual.this.removeActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAddAll, (String)NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"LBL_AddAll"));
        this.buttonAddAll.setEnabled(false);
        this.buttonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitySelectionPanelVisual.this.buttonAddAllActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemoveAll, (String)NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"LBL_RemoveAll"));
        this.buttonRemoveAll.setActionCommand(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"LBL_RemoveAll"));
        this.buttonRemoveAll.setEnabled(false);
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitySelectionPanelVisual.this.buttonRemoveAllActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.panelButtons);
        this.panelButtons.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.buttonRemove, -1, 121, Short.MAX_VALUE).add((Component)this.buttonAdd, -1, 121, Short.MAX_VALUE).add((Component)this.buttonAddAll, -1, 121, Short.MAX_VALUE).add((Component)this.buttonRemoveAll, -1, 121, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(70, 70, 70).add((Component)this.buttonAdd).add(18, 18, 18).add((Component)this.buttonRemove).add(18, 18, 18).add((Component)this.buttonAddAll).add(18, 18, 18).add((Component)this.buttonRemoveAll).addContainerGap(139, Short.MAX_VALUE)));
        this.buttonAdd.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"AddEntityClass"));
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_AddEntityClass"));
        this.buttonRemove.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"RemoveEntityClass"));
        this.buttonRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_RemoveEntityClass"));
        this.buttonAddAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"AddAllEntityClasses"));
        this.buttonAddAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_AddAllEntityClasses"));
        this.buttonRemoveAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"RemoveAllEntityClasses"));
        this.buttonRemoveAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_RemoveAllEntityClasses"));
        this.labelSelectedEntities.setLabelFor(this.listSelected);
        Mnemonics.setLocalizedText((JLabel)this.labelSelectedEntities, (String)resourceBundle.getString("LBL_SelectedEntities"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 186, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.panelButtons, -1, -1, Short.MAX_VALUE).add(7, 7, 7)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.labelAvailableEntities).addPreferredGap(0))).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 172, Short.MAX_VALUE).add((Component)this.labelSelectedEntities)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.labelAvailableEntities).add((Component)this.labelSelectedEntities)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 355, Short.MAX_VALUE).add(1, (Component)this.panelButtons, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jScrollPane2, -1, 355, Short.MAX_VALUE)).addContainerGap()));
        this.labelAvailableEntities.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"AvailableEntityClasses"));
        this.labelAvailableEntities.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_AvailableEntityClasses"));
        this.panelButtons.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"AddOrRemoveEntityClasses"));
        this.panelButtons.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_AddRemovePanel"));
        this.labelSelectedEntities.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"SelectedEntityClasses"));
        this.labelSelectedEntities.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntitySelectionPanelVisual.class, (String)"DESC_SelectedList"));
    }

    private void removeActionPerformed(ActionEvent actionEvent) {
        EntityListModel entityListModel = (EntityListModel)this.listSelected.getModel();
        EntityListModel entityListModel2 = (EntityListModel)this.listAvailable.getModel();
        for (Object object : this.listSelected.getSelectedValues()) {
            entityListModel.removeElement((Entity)object);
            if (entityListModel2.contains(object)) continue;
            entityListModel2.addElement(object);
        }
        this.refreshModel();
        this.updateButtons();
        this.fireChange();
    }

    private void addActionPerformed(ActionEvent actionEvent) {
        EntityListModel entityListModel = (EntityListModel)this.listAvailable.getModel();
        EntityListModel entityListModel2 = (EntityListModel)this.listSelected.getModel();
        HashSet<EntityClassInfo> hashSet = new HashSet<EntityClassInfo>();
        for (Object object : this.listAvailable.getSelectedValues()) {
            Entity entity = (Entity)object;
            EntityClassInfo entityClassInfo = this.builder.getEntityClassInfo(entity.getClass2());
            hashSet.addAll(entityClassInfo.getEntityClosure(hashSet));
        }
        for (EntityClassInfo entityClassInfo : hashSet) {
            entityListModel.removeElement(entityClassInfo.getEntity());
            if (entityListModel2.contains(entityClassInfo.getEntity())) continue;
            entityListModel2.addElement(entityClassInfo.getEntity());
        }
        this.refreshModel();
        this.updateButtons();
        this.fireChange();
    }

    private void listSelectedValueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireChange();
    }

    private void buttonRemoveAllActionPerformed(ActionEvent actionEvent) {
        EntityListModel entityListModel = (EntityListModel)this.listAvailable.getModel();
        EntityListModel entityListModel2 = (EntityListModel)this.listSelected.getModel();
        for (int i = 0; i < entityListModel2.getSize(); ++i) {
            entityListModel.addElement(entityListModel2.elementAt(i));
        }
        entityListModel2.clear();
        this.refreshModel();
        this.updateButtons();
        this.fireChange();
    }

    private void buttonAddAllActionPerformed(ActionEvent actionEvent) {
        EntityListModel entityListModel = (EntityListModel)this.listSelected.getModel();
        EntityListModel entityListModel2 = (EntityListModel)this.listAvailable.getModel();
        for (int i = 0; i < entityListModel2.getSize(); ++i) {
            entityListModel.addElement(entityListModel2.elementAt(i));
        }
        entityListModel2.clear();
        this.refreshModel();
        this.updateButtons();
        this.fireChange();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void read(WizardDescriptor wizardDescriptor) {
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.project.getProjectDirectory());
        if (persistenceScope == null) {
            return;
        }
        if (this.persistenceUnit == null && Util.getPersistenceUnit(wizardDescriptor, this.project) != null) {
            this.persistenceUnit = Util.getPersistenceUnit(wizardDescriptor, this.project).getName();
        }
        if (this.mappings == null) {
            this.setupModel();
        }
    }

    private void setupModel() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.project.getProjectDirectory());
        MetadataModel metadataModel = persistenceScope.getEntityMappingsModel(this.persistenceUnit);
        this.entitiesHelper = MetadataModelReadHelper.create(metadataModel, new MetadataModelAction<EntityMappingsMetadata, EntityMappings>(){

            public EntityMappings run(EntityMappingsMetadata entityMappingsMetadata) throws Exception {
                EntityMappings entityMappings = entityMappingsMetadata.getRoot();
                entityMappings.getEntity();
                return entityMappings;
            }
        });
        if (this.availableModel != null) {
            this.removeChangeListener(this.availableModel);
        }
        this.availableModel = new EntityListModel(true);
        this.listAvailable.setModel(this.availableModel);
        this.addChangeListener(this.availableModel);
        this.availableModel.addElement(MSG_RETRIEVING);
        this.listAvailable.ensureIndexIsVisible(0);
        this.entitiesHelper.addChangeListener(this.availableModel);
        this.entitiesHelper.start();
        if (this.selectedModel != null) {
            this.removeChangeListener(this.selectedModel);
        }
        this.selectedModel = new EntityListModel(false);
        this.listSelected.setModel(this.selectedModel);
        this.addChangeListener(this.selectedModel);
    }

    @Override
    public void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("EntityResourceModel", (Object)this.getResourceModel());
    }

    private void updateButtons() {
        this.buttonAdd.setEnabled(this.listAvailable.getSelectedValues().length > 0);
        this.buttonAddAll.setEnabled(this.listAvailable.getModel().getSize() > 0);
        this.buttonRemove.setEnabled(this.listSelected.getSelectedValues().length > 0);
        this.buttonRemoveAll.setEnabled(this.listSelected.getModel().getSize() > 0);
    }

    public void updatePersistenceUnitButton() {
    }

    @Override
    public boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.persistenceUnit == null || this.entitiesHelper == null) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "ERR_NoPersistenceUnit");
            return false;
        }
        if (this.entitiesHelper.isReady() && this.listAvailable.getModel().getSize() + this.listSelected.getModel().getSize() == 0) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_EntitySelectionPanel_NoEntities");
            return false;
        }
        if (this.listSelected.getModel().getSize() == 0) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_EntitySelectionPanel_NoneSelected");
            return false;
        }
        EntityResourceBeanModel entityResourceBeanModel = this.getResourceModel();
        if (entityResourceBeanModel != null && !entityResourceBeanModel.isValid()) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_EntitySelectionPanel_InvalidEntityClasses");
            return false;
        }
        AbstractPanel.clearErrorMessage(wizardDescriptor);
        return true;
    }

    private EntityResourceBeanModel getResourceModel() {
        if (this.resourceModel == null) {
            this.refreshModel();
        }
        return this.resourceModel;
    }

    private void refreshModel() {
        if (this.builder != null) {
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            for (int i = 0; i < this.listSelected.getModel().getSize(); ++i) {
                Object e = this.listSelected.getModel().getElementAt(i);
                if (!(e instanceof Entity)) continue;
                arrayList.add((Entity)e);
            }
            this.resourceModel = this.builder.build(arrayList);
        }
    }

    private final class EntityListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public EntityListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                String string2 = entity.getName();
                string = string2 + " (" + entity.getClass2() + ")";
            }
            if (string == null) {
                string = object.toString();
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(string);
            return this;
        }
    }

    private class EntityListModel
    extends DefaultListModel
    implements ChangeListener {
        private boolean available;

        EntityListModel(boolean bl) {
            this.available = bl;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.available && changeEvent.getSource() instanceof MetadataModelReadHelper) {
                switch (((MetadataModelReadHelper)changeEvent.getSource()).getState()) {
                    case FINISHED: {
                        if (EntitySelectionPanelVisual.this.mappings != null || !EntitySelectionPanelVisual.this.entitiesHelper.isReady()) break;
                        try {
                            EntitySelectionPanelVisual.this.mappings = EntitySelectionPanelVisual.this.entitiesHelper.getResult();
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.ALL, "stateChanged", executionException);
                            throw new IllegalStateException(executionException);
                        }
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                HashMap<String, Entity> hashMap = new HashMap<String, Entity>();
                                for (Entity entity : RuntimeJpaEntity.getEntityFromClasspath(EntitySelectionPanelVisual.this.project)) {
                                    if (hashMap.get(entity.getClass2()) != null) continue;
                                    hashMap.put(entity.getClass2(), entity);
                                }
                                for (Entity entity : EntitySelectionPanelVisual.this.mappings.getEntity()) {
                                    if (hashMap.get(entity.getClass2()) != null) continue;
                                    hashMap.put(entity.getClass2(), entity);
                                }
                                EntitySelectionPanelVisual.this.builder = new EntityResourceModelBuilder(EntitySelectionPanelVisual.this.project, hashMap.values());
                                if (EntitySelectionPanelVisual.this.builder.getEntities().size() == hashMap.size() || EntitySelectionPanelVisual.this.retryCount++ > 10) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            EntityListModel.this.removeElement(MSG_RETRIEVING);
                                            for (Entity entity : EntitySelectionPanelVisual.this.builder.getValidEntities()) {
                                                EntityListModel.this.addElement(entity);
                                            }
                                            EntitySelectionPanelVisual.this.updateButtons();
                                        }
                                    });
                                } else {
                                    EntitySelectionPanelVisual.this.mappings = null;
                                    EntitySelectionPanelVisual.this.setupModel();
                                }
                            }
                        });
                        break;
                    }
                }
            }
        }
    }
}

