/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.DeleteAction;
import org.netbeans.modules.localhistory.ui.view.RevertFileAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class StoreEntryNode
extends AbstractNode
implements Comparable {
    static final String PROPERTY_NAME_LABEL = "label";
    private List<StoreEntry> entries;
    private static DateFormat defaultFormat = DateFormat.getDateTimeInstance();

    private StoreEntryNode(List<StoreEntry> childrenEntries) {
        super(StoreEntryNode.createChildren(childrenEntries));
        this.entries = childrenEntries;
        this.initProperties();
    }

    private StoreEntryNode(List<StoreEntry> childrenEntries, Lookup l) {
        super(Children.LEAF, l);
        this.entries = childrenEntries;
        this.initProperties();
    }

    static StoreEntryNode create(List<StoreEntry> childrenEntries) {
        assert (childrenEntries != null && childrenEntries.size() > 0);
        if (childrenEntries.size() > 1) {
            for (StoreEntry entry : childrenEntries) {
                entry.setSiblings(childrenEntries);
            }
            return new StoreEntryNode(childrenEntries);
        }
        return new StoreEntryNode(childrenEntries, Lookups.fixed((Object[])new Object[]{childrenEntries.get(0)}));
    }

    private static Children createChildren(List<StoreEntry> childrenEntries) {
        FileNode[] nodes = new FileNode[childrenEntries.size()];
        int i = 0;
        for (StoreEntry se : childrenEntries) {
            nodes[i++] = new FileNode(se);
        }
        Children.SortedArray children = new Children.SortedArray();
        children.add((Node[])nodes);
        return children;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new LabelProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return StoreEntryNode.getFormatedDate(this.entries.get(0));
    }

    static String getFormatedDate(StoreEntry se) {
        return defaultFormat.format(se.getDate());
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(RevertFileAction.class), SystemAction.get(DeleteAction.class)};
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof StoreEntryNode) || obj == null) {
            return 1;
        }
        StoreEntryNode node = (StoreEntryNode)obj;
        if (node.entries.get(0).getTimestamp() > this.entries.get(0).getTimestamp()) {
            return 1;
        }
        if (node.entries.get(0).getTimestamp() < this.entries.get(0).getTimestamp()) {
            return -1;
        }
        return 0;
    }

    private static class FileNode
    extends AbstractNode
    implements Comparable {
        private final StoreEntry entry;

        FileNode(StoreEntry entry) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{entry}));
            this.entry = entry;
        }

        public Action[] getActions(boolean context) {
            ArrayList<StoreEntry> entries = new ArrayList<StoreEntry>(1);
            entries.add(this.entry);
            return new Action[]{SystemAction.get(RevertFileAction.class), SystemAction.get(DeleteAction.class)};
        }

        public String getName() {
            return this.entry.getFile().getName();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof FileNode) || obj == null) {
                return -1;
            }
            FileNode node = (FileNode)obj;
            return this.getName().compareTo(node.getName());
        }
    }

    private class LabelProperty
    extends PropertySupport.ReadWrite<String> {
        public LabelProperty() {
            super(StoreEntryNode.PROPERTY_NAME_LABEL, String.class, NbBundle.getMessage(StoreEntryNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(StoreEntryNode.class, (String)"LBL_LabelProperty_Desc"));
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return ((StoreEntry)StoreEntryNode.this.entries.get(0)).getLabel();
        }

        public void setValue(String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            value = value.trim();
            ArrayList<StoreEntry> newEntries = new ArrayList<StoreEntry>(StoreEntryNode.this.entries.size());
            for (StoreEntry se : StoreEntryNode.this.entries) {
                LocalHistory.getInstance().getLocalHistoryStore().setLabel(se.getFile(), se.getTimestamp(), !value.equals("") ? value : null);
                newEntries.add(StoreEntry.createStoreEntry(se.getFile(), se.getStoreFile(), se.getTimestamp(), value));
            }
            StoreEntryNode.this.entries = newEntries;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport();
        }
    }
}

