/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.hostinfo.HostInfoProvider;
import org.netbeans.modules.nativeexecution.support.hostinfo.impl.HostInfoFactory;
import org.openide.util.Utilities;

public class WindowsHostInfoProvider
implements HostInfoProvider {
    @Override
    public HostInfo getHostInfo(ExecutionEnvironment execEnv) throws IOException {
        if (!execEnv.isLocal() || !Utilities.isWindows()) {
            return null;
        }
        HostInfoImpl info = new HostInfoImpl();
        info.initTmpDirs();
        info.initUserDirs();
        return info;
    }

    private static class HostInfoImpl
    implements HostInfo {
        private final HostInfo.OS os;
        private final HostInfo.Bitness osBitness;
        private final HostInfo.OSFamily osFamily;
        private final String osVersion;
        private final String osName;
        private final HostInfo.CpuFamily cpuFamily;
        private final int cpuNum;
        private final String hostname;
        private final String shell;
        private File tmpDirFile;
        private String tmpDir;
        private File userDirFile;
        private String userDir;
        private Map<String, String> environment;

        HostInfoImpl() {
            Map<String, String> env = new ProcessBuilder("").environment();
            this.osBitness = "x86".equals(System.getProperty("os.arch")) ? HostInfo.Bitness._32 : HostInfo.Bitness._64;
            this.osFamily = HostInfo.OSFamily.WINDOWS;
            this.osVersion = System.getProperty("os.version");
            this.osName = System.getProperty("os.name");
            this.cpuFamily = HostInfo.CpuFamily.X86;
            int _cpuNum = 1;
            try {
                _cpuNum = Integer.parseInt(env.get("NUMBER_OF_PROCESSORS"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.cpuNum = _cpuNum;
            this.hostname = env.get("COMPUTERNAME");
            this.shell = WindowsSupport.getInstance().getShell();
            if (this.shell != null) {
                String path = new File(this.shell).getParent();
                if (env.containsKey("Path")) {
                    path = path + ";" + env.get("Path");
                    env.put("Path", path);
                } else if (env.containsKey("PATH")) {
                    path = path + ";" + env.get("PATH");
                    env.put("PATH", path);
                }
            }
            this.environment = Collections.unmodifiableMap(env);
            this.os = new HostInfo.OS(){

                @Override
                public HostInfo.OSFamily getFamily() {
                    return HostInfoImpl.this.osFamily;
                }

                @Override
                public String getName() {
                    return HostInfoImpl.this.osName;
                }

                @Override
                public String getVersion() {
                    return HostInfoImpl.this.osVersion;
                }

                @Override
                public HostInfo.Bitness getBitness() {
                    return HostInfoImpl.this.osBitness;
                }
            };
        }

        public void initTmpDirs() throws IOException {
            File _tmpDirFile = null;
            String _tmpDir = null;
            String ioTmpDir = System.getProperty("java.io.tmpdir");
            String username = this.environment.get("USERNAME");
            if (username != null) {
                for (int i = 0; i < username.length(); ++i) {
                    char c = username.charAt(i);
                    if (Character.isDigit(c) || c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                    username = "" + username.hashCode();
                    break;
                }
            }
            _tmpDirFile = new File(ioTmpDir, "dlight_" + username);
            _tmpDirFile = new File(_tmpDirFile, HostInfoFactory.getNBKey());
            _tmpDir = _tmpDirFile.getAbsolutePath();
            if (this.shell != null) {
                _tmpDir = WindowsSupport.getInstance().convertToShellPath(_tmpDir);
            }
            if (!_tmpDirFile.exists() && !_tmpDirFile.mkdirs()) {
                throw new IOException("Unable to create tmpdir " + _tmpDirFile);
            }
            this.tmpDirFile = _tmpDirFile;
            this.tmpDir = _tmpDir;
        }

        public void initUserDirs() throws IOException {
            File _userDirFile = null;
            String _userDir = null;
            String ioUserDir = System.getProperty("user.home");
            String username = this.environment.get("USERNAME");
            if (username != null) {
                for (int i = 0; i < username.length(); ++i) {
                    char c = username.charAt(i);
                    if (Character.isDigit(c) || c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                    username = "" + username.hashCode();
                    break;
                }
            }
            _userDirFile = new File(ioUserDir);
            _userDir = _userDirFile.getAbsolutePath();
            if (this.shell != null) {
                _userDir = WindowsSupport.getInstance().convertToShellPath(_userDir);
            }
            this.userDirFile = _userDirFile;
            this.userDir = _userDir;
        }

        @Override
        public HostInfo.OS getOS() {
            return this.os;
        }

        @Override
        public HostInfo.CpuFamily getCpuFamily() {
            return this.cpuFamily;
        }

        @Override
        public int getCpuNum() {
            return this.cpuNum;
        }

        @Override
        public HostInfo.OSFamily getOSFamily() {
            return this.osFamily;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }

        @Override
        public String getShell() {
            return this.shell;
        }

        @Override
        public String getLoginShell() {
            return this.shell;
        }

        @Override
        public String getTempDir() {
            return this.tmpDir;
        }

        @Override
        public File getTempDirFile() {
            return this.tmpDirFile;
        }

        @Override
        public String getUserDir() {
            return this.userDir;
        }

        @Override
        public File getUserDirFile() {
            return this.userDirFile;
        }

        @Override
        public long getClockSkew() {
            return 0L;
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.environment;
        }
    }
}

