/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.FinalFieldsFromCtorCustomiser;
import org.netbeans.modules.java.hints.errors.LocalVariableFixCustomizer;
import org.netbeans.modules.java.hints.errors.SurroundWithTryCatchLog;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ErrorFixesFakeHint
extends AbstractHint {
    private FixKind kind;
    private static Map<FixKind, ErrorFixesFakeHint> kind2Hint = new EnumMap<FixKind, ErrorFixesFakeHint>(FixKind.class);
    public static final String LOCAL_VARIABLES_INPLACE = "create-local-variables-in-place";
    public static final String SURROUND_USE_EXCEPTIONS = "surround-try-catch-org-openide-util-Exceptions";
    public static final String SURROUND_USE_JAVA_LOGGER = "surround-try-catch-java-util-logging-Logger";
    public static final String FINAL_FIELDS_FROM_CTOR = "create-final-fields-from-ctor";

    private ErrorFixesFakeHint(FixKind kind) {
        super(true, false, null, new String[0]);
        this.kind = kind;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ErrorFixesFakeHint.class, (String)("DESC_ErrorFixesFakeHint" + this.kind.name()));
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.noneOf(Tree.Kind.class);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return null;
    }

    @Override
    public String getId() {
        return ErrorFixesFakeHint.class.getName() + this.kind.name();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ErrorFixesFakeHint.class, (String)("DN_ErrorFixesFakeHint" + this.kind.name()));
    }

    @Override
    public void cancel() {
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        switch (this.kind) {
            case CREATE_LOCAL_VARIABLE: {
                return new LocalVariableFixCustomizer(node);
            }
            case SURROUND_WITH_TRY_CATCH: {
                return new SurroundWithTryCatchLog(node);
            }
            case CREATE_FINAL_FIELD_CTOR: {
                return new FinalFieldsFromCtorCustomiser(node);
            }
        }
        return super.getCustomizer(node);
    }

    private static synchronized ErrorFixesFakeHint getHint(FixKind kind) {
        ErrorFixesFakeHint h = kind2Hint.get((Object)kind);
        if (h == null) {
            h = new ErrorFixesFakeHint(kind);
            kind2Hint.put(kind, h);
        }
        return h;
    }

    public static boolean enabled(FixKind kind) {
        return ErrorFixesFakeHint.getHint(kind).isEnabled();
    }

    public static boolean isCreateFinalFieldsForCtor() {
        return ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR).getPreferences(null).getBoolean(FINAL_FIELDS_FROM_CTOR, true);
    }

    public static void setCreateFinalFieldsForCtor(Preferences p, boolean v) {
        p.putBoolean(FINAL_FIELDS_FROM_CTOR, v);
    }

    public static void setCreateFinalFieldsForCtor(boolean v) {
        ErrorFixesFakeHint.setCreateFinalFieldsForCtor(ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR).getPreferences(null), v);
    }

    public static boolean isCreateLocalVariableInPlace() {
        return ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE).getPreferences(null).getBoolean(LOCAL_VARIABLES_INPLACE, true);
    }

    public static void setCreateLocalVariableInPlace(boolean v) {
        ErrorFixesFakeHint.setCreateLocalVariableInPlace(ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE).getPreferences(null), v);
    }

    public static void setCreateLocalVariableInPlace(Preferences p, boolean v) {
        p.putBoolean(LOCAL_VARIABLES_INPLACE, v);
    }

    public static boolean isUseExceptions() {
        return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null).getBoolean(SURROUND_USE_EXCEPTIONS, true);
    }

    public static void setUseExceptions(boolean v) {
        ErrorFixesFakeHint.setUseExceptions(ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null), v);
    }

    public static void setUseExceptions(Preferences p, boolean v) {
        p.putBoolean(SURROUND_USE_EXCEPTIONS, v);
    }

    public static boolean isUseLogger() {
        return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null).getBoolean(SURROUND_USE_JAVA_LOGGER, true);
    }

    public static void setUseLogger(boolean v) {
        ErrorFixesFakeHint.setUseLogger(ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null), v);
    }

    public static void setUseLogger(Preferences p, boolean v) {
        p.putBoolean(SURROUND_USE_JAVA_LOGGER, v);
    }

    public static ErrorFixesFakeHint create(FileObject file) {
        if (file.getName().endsWith("surround")) {
            return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH);
        }
        if (file.getName().endsWith("local")) {
            return ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE);
        }
        if (file.getName().endsWith("finalfield")) {
            return ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR);
        }
        throw new IllegalArgumentException();
    }

    public static enum FixKind {
        SURROUND_WITH_TRY_CATCH,
        CREATE_LOCAL_VARIABLE,
        CREATE_FINAL_FIELD_CTOR;

    }
}

