/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.io.IOException;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JMenuItem;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.java.hints.infrastructure.HintAction;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class IntroduceAction
extends HintAction {
    private final IntroduceKind type;
    private static final String MENU_TEXT = "menuText";
    private static final String POPUP_TEXT = "popupText";

    private IntroduceAction(IntroduceKind introduceKind) {
        super(introduceKind.getKey());
        this.type = introduceKind;
        switch (introduceKind) {
            case CREATE_CONSTANT: {
                this.putValue("Name", introduceKind.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                break;
            }
            case CREATE_VARIABLE: {
                this.putValue("Name", introduceKind.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                break;
            }
            case CREATE_FIELD: {
                this.putValue("Name", introduceKind.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                break;
            }
            case CREATE_METHOD: {
                this.putValue("Name", introduceKind.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
            }
        }
        this.setEnabled(true);
    }

    @Override
    protected void perform(JavaSource javaSource, int[] nArray) {
        String string = this.doPerformAction(javaSource, nArray);
        if (string != null) {
            String string2 = NbBundle.getMessage(IntroduceAction.class, (String)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }

    private String doPerformAction(final JavaSource javaSource, final int[] nArray) {
        final EnumMap enumMap = new EnumMap(IntroduceKind.class);
        final EnumMap enumMap2 = new EnumMap(IntroduceKind.class);
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.RESOLVED);
                            if (atomicBoolean.get()) {
                                return;
                            }
                            IntroduceHint.computeError((CompilationInfo)compilationController, nArray[0], nArray[1], enumMap, enumMap2, atomicBoolean);
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }, (String)NbBundle.getMessage(IntroduceAction.class, (String)"LBL_Indroduce_Action"), (AtomicBoolean)atomicBoolean, (boolean)false);
        if (atomicBoolean.get()) {
            return null;
        }
        Fix fix = (Fix)enumMap.get((Object)this.type);
        if (fix != null) {
            try {
                fix.implement();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            return null;
        }
        String string = (String)enumMap2.get((Object)this.type);
        if (string != null) {
            return string;
        }
        return "ERR_Invalid_Selection";
    }

    public static IntroduceAction createVariable() {
        return new IntroduceAction(IntroduceKind.CREATE_VARIABLE);
    }

    public static IntroduceAction createConstant() {
        return new IntroduceAction(IntroduceKind.CREATE_CONSTANT);
    }

    public static IntroduceAction createField() {
        return new IntroduceAction(IntroduceKind.CREATE_FIELD);
    }

    public static IntroduceAction createMethod() {
        return new IntroduceAction(IntroduceKind.CREATE_METHOD);
    }

    public static Object createVariableGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"), IntroduceKind.CREATE_VARIABLE.getKey());
    }

    public static Object createConstantGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"), IntroduceKind.CREATE_CONSTANT.getKey());
    }

    public static Object createFieldGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"), IntroduceKind.CREATE_FIELD.getKey());
    }

    public static Object createMethodGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"), IntroduceKind.CREATE_METHOD.getKey());
    }

    private static final class GlobalActionImpl
    extends MainMenuAction
    implements Presenter.Popup {
        private final String menuItemText;
        private final String actionName;

        public GlobalActionImpl(String string, String string2) {
            this.menuItemText = string;
            this.actionName = string2;
            this.setMenu();
        }

        protected String getMenuItemText() {
            return this.menuItemText;
        }

        protected String getActionName() {
            return this.actionName;
        }

        public JMenuItem getPopupPresenter() {
            return this.getMenuPresenter();
        }
    }
}

