/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;

public abstract class FlowPinPresenter
extends FlowPresenter
implements FlowPresenter.FlowUIResolver {
    private FlowNodeDescriptor node = null;
    private FlowPinDescriptor pin = null;

    @Override
    public final void resolveRemoveBadge() {
    }

    @Override
    public final void resolveRemoveEdge() {
    }

    @Override
    public final void resolveRemovePin() {
        FlowPinDescriptor newPin;
        FlowNodeDescriptor newNode;
        if (this.isVisible()) {
            newNode = this.getNodeDescriptor();
            newPin = newNode != null ? this.getPinDescriptor() : null;
        } else {
            newNode = null;
            newPin = null;
        }
        if (!FlowPinPresenter.equals(this.node, newNode) || !FlowPinPresenter.equals(this.pin, newPin)) {
            if (this.pin != null) {
                FlowScene scene = this.getScene();
                scene.removePin(this.pin);
                scene.unregisterUI(this.pin, (FlowPresenter.FlowUIResolver)this);
                scene.scheduleNodeDescriptorForOrdering(this.node);
            }
            this.node = newNode;
            this.pin = newPin;
        }
    }

    @Override
    public final void resolveRemoveNode() {
    }

    @Override
    public final void resolveAddNode() {
    }

    @Override
    public final void resolveAddPin() {
        FlowScene scene;
        if (this.pin != null && !(scene = this.getScene()).isObject(this.pin)) {
            scene.registerUI(this.pin, (FlowPresenter.FlowUIResolver)this);
            scene.addPin(this.node, this.pin);
            scene.updateBadges(this.pin);
            scene.scheduleNodeDescriptorForOrdering(this.node);
        }
    }

    @Override
    public final void resolveAddEdge() {
    }

    @Override
    public final void resolveAddBadge() {
    }

    @Override
    public final void resolveUpdate() {
        if (this.pin != null) {
            this.getScene().getDecorator(this.pin).update(this.pin, this.getScene());
        }
    }

    @Override
    public final Collection<? extends FlowDescriptor> getFlowDescriptors() {
        return this.pin != null ? Collections.singleton(this.pin) : Collections.emptySet();
    }

    protected abstract FlowNodeDescriptor getNodeDescriptor();

    protected abstract FlowPinDescriptor getPinDescriptor();

    @Override
    public abstract FlowPinDescriptor.PinDecorator getDecorator();

    @Override
    public abstract FlowPinDescriptor.PinBehaviour getBehaviour();
}

