/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.Sudo;
import org.netbeans.modules.ruby.platform.gems.GemInstallInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.GemProgressPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class GemRunner {
    private static final Logger LOGGER = Logger.getLogger(GemRunner.class.getName());
    private final RubyPlatform platform;
    private List<String> output;
    private File pwd;

    GemRunner(RubyPlatform platform) {
        this.platform = platform;
        assert (platform.hasRubyGemsInstalled()) : "GemRunner cannot be used fro platform without RubyGems: " + platform;
    }

    private String[] getOptions(String ... custom) {
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(Arrays.asList(custom));
        if (RubyPreferences.shallFetchGemDescriptions()) {
            options.add("--details");
        }
        if (!this.platform.getGemManager().hasAncientRubyGemsVersion() && RubyPreferences.shallFetchAllVersions()) {
            options.add("--all");
        }
        return options.toArray(new String[options.size()]);
    }

    boolean fetchBoth() {
        return this.runGemTool("list", false, this.getOptions("--both"));
    }

    boolean fetchRemote() {
        return this.runGemTool("list", false, this.getOptions("--remote"));
    }

    boolean fetchLocal() {
        return this.runGemTool("list", false, this.getOptions("--local"));
    }

    boolean install(List<String> gemNames, boolean rdoc, boolean ri, boolean includeDeps, String version) {
        return this.installRemote(gemNames, rdoc, ri, includeDeps, version, null, null);
    }

    boolean installLocal(File gem, boolean rdoc, boolean ri) {
        return this.installLocal(gem, rdoc, ri, null, null);
    }

    boolean installAsynchronously(List<String> gemNames, boolean rdoc, boolean ri, boolean includeDeps, String version, Runnable asyncCompletionTask, Component parent) {
        return this.installRemote(gemNames, rdoc, ri, includeDeps, version, asyncCompletionTask, parent);
    }

    boolean installLocalAsynchronously(File gem, boolean rdoc, boolean ri, Runnable asyncCompletionTask, Component parent) {
        return this.installLocal(gem, rdoc, ri, asyncCompletionTask, parent);
    }

    boolean update(List<String> gemNames, boolean rdoc, boolean ri, boolean includeDependencies) {
        return this.update(gemNames, rdoc, ri, includeDependencies, null, null);
    }

    boolean updateAsynchronously(List<String> gemNames, boolean rdoc, boolean ri, boolean includeDependencies, Runnable asyncCompletionTask, Component parent) {
        return this.update(gemNames, rdoc, ri, includeDependencies, asyncCompletionTask, parent);
    }

    boolean uninstall(List<GemInstallInfo> gems) {
        return this.uninstall(gems, null, null);
    }

    boolean uninstallAsynchronously(List<GemInstallInfo> gems, Runnable asyncCompletionTask, Component parent) {
        return this.uninstall(gems, asyncCompletionTask, parent);
    }

    private boolean install(List<String> gems, boolean rdoc, boolean ri, boolean includeDeps, String version, Runnable asyncCompletionTask, Component parent) {
        ArrayList<String> argList = new ArrayList<String>();
        for (String gem : gems) {
            argList.add(gem);
        }
        if (!rdoc) {
            argList.add("--no-rdoc");
        }
        if (!ri) {
            argList.add("--no-ri");
        }
        if (includeDeps) {
            this.includeDeps(argList);
        } else {
            argList.add("--ignore-dependencies");
        }
        if (version != null && version.length() > 0) {
            argList.add("--version");
            argList.add(version);
        }
        String[] args = argList.toArray(new String[argList.size()]);
        String gemCmd = "install";
        if (asyncCompletionTask != null) {
            String title = NbBundle.getMessage(GemRunner.class, (String)"Installation");
            String success = NbBundle.getMessage(GemRunner.class, (String)"InstallationOk");
            String failure = NbBundle.getMessage(GemRunner.class, (String)"InstallationFailed");
            this.asynchGemRunner(parent, title, success, failure, asyncCompletionTask, gemCmd, args);
            return false;
        }
        return this.runGemTool(gemCmd, args);
    }

    private boolean installRemote(List<String> gemNames, boolean rdoc, boolean ri, boolean includeDeps, String version, Runnable asyncCompletionTask, Component parent) {
        return this.install(gemNames, rdoc, ri, includeDeps, version, asyncCompletionTask, parent);
    }

    private boolean installLocal(File gem, boolean rdoc, boolean ri, Runnable asyncCompletionTask, Component parent) {
        this.pwd = gem.getParentFile();
        return this.install(Collections.singletonList(gem.getName()), rdoc, ri, false, null, asyncCompletionTask, parent);
    }

    private boolean update(List<String> gemNames, boolean rdoc, boolean ri, boolean includeDependencies, Runnable asyncCompletionTask, Component parent) {
        ArrayList<String> argList = new ArrayList<String>();
        if (gemNames != null) {
            for (String gemName : gemNames) {
                argList.add(gemName);
            }
        }
        if (RubyPreferences.isGemVerboseOutput()) {
            argList.add("--verbose");
        }
        if (!rdoc) {
            argList.add("--no-rdoc");
        }
        if (!ri) {
            argList.add("--no-ri");
        }
        if (includeDependencies) {
            argList.add("--include-dependencies");
        }
        this.includeDeps(argList);
        String[] args = argList.toArray(new String[argList.size()]);
        String gemCmd = "update";
        if (asyncCompletionTask != null) {
            String title = NbBundle.getMessage(GemRunner.class, (String)"Update");
            String success = NbBundle.getMessage(GemRunner.class, (String)"UpdateOk");
            String failure = NbBundle.getMessage(GemRunner.class, (String)"UpdateFailed");
            this.asynchGemRunner(parent, title, success, failure, asyncCompletionTask, gemCmd, args);
            return false;
        }
        return this.runGemTool(gemCmd, args);
    }

    private static String[] uninstallArgsFor(GemInstallInfo info) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(info.getName());
        if (info.getVersion() == null) {
            argList.add("--all");
        } else {
            argList.add("-v " + info.getVersion());
        }
        argList.add("--executables");
        if (info.isIgnoreDependencies()) {
            argList.add("--ignore-dependencies");
        }
        return argList.toArray(new String[argList.size()]);
    }

    private boolean uninstall(List<GemInstallInfo> gems, Runnable asyncCompletionTask, Component parent) {
        String gemCmd = "uninstall";
        if (asyncCompletionTask != null) {
            String title = NbBundle.getMessage(GemRunner.class, (String)"Uninstallation");
            String success = NbBundle.getMessage(GemRunner.class, (String)"UninstallationOk");
            String failure = NbBundle.getMessage(GemRunner.class, (String)"UninstallationFailed");
            for (GemInstallInfo gem : gems) {
                this.asynchGemRunner(parent, title, success, failure, asyncCompletionTask, "uninstall", GemRunner.uninstallArgsFor(gem));
            }
            return false;
        }
        boolean ok = true;
        for (GemInstallInfo gem : gems) {
            ok = this.runGemTool("uninstall", GemRunner.uninstallArgsFor(gem));
        }
        return ok;
    }

    List<String> getOutput() {
        return this.output;
    }

    private void includeDeps(List<String> argList) {
        if (Util.compareVersions(this.platform.getInfo().getGemVersion(), "0.9.5") < 0) {
            argList.add("--include-dependencies");
        }
    }

    private boolean runGemTool(String gemCommand, boolean needsWrite, String ... commandArgs) {
        return this.runGemTool(gemCommand, needsWrite, (GemProgressPanel)null, (Process[])null, commandArgs);
    }

    private boolean runGemTool(String gemCommand, String ... commandArgs) {
        return this.runGemTool(gemCommand, true, commandArgs);
    }

    private boolean runGemTool(String gemCommand, boolean needsWrite, GemProgressPanel progressPanel, Process[] processHolder, String ... commandArgs) {
        int exitCode;
        block20: {
            List<String> argList = new ArrayList<String>();
            File cmd = new File(this.platform.getInterpreter());
            if (!cmd.getName().startsWith("jruby") || ExecutionUtils.launchJRubyScript()) {
                argList.add(cmd.getPath());
            }
            argList.addAll(ExecutionUtils.getRubyArgs(this.platform));
            GemManager gemManager = this.platform.getGemManager();
            assert (gemManager != null) : "gemManager cannot be null";
            File gemToolDir = new File(this.platform.getGemTool()).getParentFile().getParentFile();
            argList.add("-I" + gemToolDir + "/" + "lib");
            argList.add(this.platform.getGemTool());
            argList.add(gemCommand);
            for (String arg : commandArgs) {
                argList.add(arg);
            }
            if (needsWrite && !gemManager.isGemHomeWritable()) {
                String message = NbBundle.getMessage(GemRunner.class, (String)"GemRunner.message.for.sudo");
                Sudo sudo = new Sudo(argList, message);
                argList = sudo.createCommand();
            }
            String[] args = argList.toArray(new String[argList.size()]);
            ProcessBuilder pb = new ProcessBuilder(args);
            GemManager.adjustEnvironment(this.platform, pb.environment());
            pb.directory(this.pwd == null ? cmd.getParentFile() : this.pwd);
            pb.redirectErrorStream(true);
            Util.adjustProxy(pb);
            RubyExecutionDescriptor descriptor = new RubyExecutionDescriptor(this.platform, "gem", pb.directory()).cmd(cmd);
            ExecutionUtils.setupProcessEnvironment(pb.environment(), descriptor.getCmd().getParent(), descriptor.getAppendJdkToPath());
            if (this.output == null) {
                this.output = new ArrayList<String>(40);
            }
            exitCode = -1;
            try {
                String message;
                String line;
                BufferedReader br;
                InputStreamReader isr;
                InputStream is;
                Process process;
                block19: {
                    ExecutionUtils.logProcess(pb);
                    pb.redirectErrorStream(true);
                    process = pb.start();
                    if (processHolder != null) {
                        processHolder[0] = process;
                    }
                    is = process.getInputStream();
                    if (progressPanel != null) {
                        progressPanel.setProcessInput(process.getOutputStream());
                    }
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    try {
                        while ((line = br.readLine()) != null) {
                            if (progressPanel != null) {
                                progressPanel.appendOutput(line);
                            }
                            this.output.add(line);
                        }
                    }
                    catch (IOException ioe) {
                        message = "*** Gem Process Killed ***\n";
                        this.output.add(message);
                        if (progressPanel == null) break block19;
                        progressPanel.appendOutput(message);
                    }
                }
                if ((exitCode = process.waitFor()) == 0) break block20;
                try {
                    is = process.getErrorStream();
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (progressPanel != null) {
                            progressPanel.appendOutput(line);
                        }
                        this.output.add(line);
                    }
                }
                catch (IOException ioe) {
                    message = "*** Gem Process Killed ***\n";
                    this.output.add(message);
                    if (progressPanel != null) {
                        progressPanel.appendOutput(message);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        LOGGER.finer("Process finished with exit code: " + exitCode);
        boolean succeeded = exitCode == 0;
        return succeeded;
    }

    private void asynchGemRunner(final Component parent, String description, final String successMessage, final String failureMessage, final Runnable successCompletionTask, final String gemCommand, final String ... commandArgs) {
        Cursor originalCursor;
        if (!EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)"#asynchGemRunner must be called from EDT");
        }
        if (parent != null) {
            originalCursor = parent.getCursor();
            Cursor busy = Cursor.getPredefinedCursor(3);
            parent.setCursor(busy);
        } else {
            originalCursor = null;
        }
        final JButton closeButton = new JButton(NbBundle.getMessage(GemRunner.class, (String)"CTL_Close"));
        final JButton cancelButton = new JButton(NbBundle.getMessage(GemRunner.class, (String)"CTL_Cancel"));
        closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemRunner.class, (String)"AD_Close"));
        Object[] options = new Object[]{closeButton, cancelButton};
        closeButton.setEnabled(false);
        final GemProgressPanel progress = new GemProgressPanel(NbBundle.getMessage(GemRunner.class, (String)"GemPleaseWait"));
        progress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemRunner.class, (String)"GemProgressPanel.AccessibleContext.accessibleDescription"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)progress, description, true, options, (Object)closeButton, 0, new HelpCtx(GemRunner.class), null);
        descriptor.setModal(true);
        final Process[] processHolder = new Process[1];
        final Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                dlg.setVisible(false);
                dlg.dispose();
                GemRunner.resetCursor(parent, originalCursor);
            }
        });
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final boolean succeeded = GemRunner.this.runGemTool(gemCommand, true, progress, processHolder, commandArgs);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            closeButton.setEnabled(true);
                            cancelButton.setEnabled(false);
                            progress.done(succeeded ? successMessage : failureMessage);
                        }
                    });
                    if (succeeded && successCompletionTask != null) {
                        successCompletionTask.run();
                    }
                }
                finally {
                    GemRunner.resetCursor(parent, originalCursor);
                }
            }
        };
        RequestProcessor.getDefault().post(runner, 50);
        dlg.setVisible(true);
        if (descriptor.getValue() == DialogDescriptor.CANCEL_OPTION || descriptor.getValue() == cancelButton) {
            GemRunner.resetCursor(parent, originalCursor);
            cancelButton.setEnabled(false);
            Process process = processHolder[0];
            if (process != null) {
                process.destroy();
                dlg.setVisible(false);
                dlg.dispose();
            }
        }
    }

    private static void resetCursor(final Component parent, final Cursor originalCursor) {
        if (parent != null) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GemRunner.resetCursor(parent, originalCursor);
                    }
                });
                return;
            }
            parent.setCursor(originalCursor);
        }
    }
}

