/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties;

import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.CustomErrorMessageProvider;

public class Color
implements CssPropertyValueAcceptor,
CustomErrorMessageProvider {
    private static final String[] COLORS = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "orange", "purple", "red", "silver", "teal", "white", "yellow]", "inherit"};
    private String errorMsg = null;

    @Override
    public String id() {
        return "color";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean accepts(String token) {
        if (token.length() == 0) {
            return true;
        }
        if (token.startsWith("#")) {
            String number = token.substring(1);
            if (number.length() != 3 && number.length() != 6) {
                this.errorMsg = "Unexpected length of hexadecimal color definition";
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= number.length()) {
                    return true;
                }
                char c = number.charAt(i);
                if (!(Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                    this.errorMsg = "Unexpected character '" + c + "' in haxadecimal color value";
                    return false;
                }
                ++i;
            }
        }
        int i = 0;
        while (true) {
            if (i >= COLORS.length) {
                this.errorMsg = "Invalid color name";
                return false;
            }
            if (COLORS[i].equalsIgnoreCase(token)) {
                return true;
            }
            ++i;
        }
    }

    @Override
    public String customErrorMessage() {
        return this.errorMsg;
    }
}

