/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.listener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.listener.ListenerNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ListenersNode
extends ContainerNode {
    private static final String LISTENERS_STRING = NbBundle.getMessage(ListenersNode.class, (String)"ListenersNode_ListenersString");

    public ListenersNode(ContainerNode containerNode) {
        super(LISTENERS_STRING, (Icon)Utils.PACKAGE_ICON, containerNode);
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    private static class Children
    extends GreedySelectorChildren<ListenersNode> {
        private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();

        public Children() {
            this.scope.add(ClassIndex.SearchScope.SOURCE);
            this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
        }

        protected List<SelectorNode> prepareChildren(ListenersNode listenersNode) {
            HashSet<SelectorNode> hashSet = new HashSet<SelectorNode>();
            try {
                Project project = (Project)listenersNode.getLookup().lookup(Project.class);
                ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project);
                Collection<FileObject> collection = WebProjectUtils.getDeploymentDescriptorFileObjects(project, true);
                for (FileObject fileObject : collection) {
                    this.enumerateListeners(hashSet, listenersNode, classpathInfo, fileObject);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return new ArrayList<SelectorNode>(hashSet);
        }

        private void enumerateListeners(final Collection<SelectorNode> collection, final ListenersNode listenersNode, final ClasspathInfo classpathInfo, FileObject fileObject) throws IOException, IllegalArgumentException {
            final WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (Listener listener : webApp.getListener()) {
                        TypeElement typeElement = compilationController.getElements().getTypeElement(listener.getListenerClass());
                        if (typeElement == null) continue;
                        collection.add(new ListenerNode(classpathInfo, typeElement, listenersNode));
                    }
                }
            }, true);
        }
    }
}

