/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.ExpressionTree;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class JavadocGenerator {
    private final SourceVersion srcVersion;
    private String author = System.getProperty("user.name");

    public JavadocGenerator(SourceVersion sourceVersion) {
        this.srcVersion = sourceVersion;
    }

    public String generateComment(TypeElement typeElement, CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder("/**\n\n");
        if (typeElement.getNestingKind() == NestingKind.TOP_LEVEL) {
            stringBuilder.append("@author " + this.author + "\n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0) {
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                stringBuilder.append("@param <" + typeParameterElement.getSimpleName().toString() + "> \n");
            }
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(compilationInfo, typeElement)) {
            stringBuilder.append("@deprecated\n");
        }
        stringBuilder.append("*/\n");
        return stringBuilder.toString();
    }

    public String generateComment(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder("/**\n\n");
        for (TypeParameterElement object2 : executableElement.getTypeParameters()) {
            stringBuilder.append("@param <").append(object2.getSimpleName().toString()).append("> \n");
        }
        Object object3 = executableElement.getParameters().iterator();
        while (object3.hasNext()) {
            VariableElement variableElement = (VariableElement)object3.next();
            stringBuilder.append("@param ").append(variableElement.getSimpleName().toString()).append(" \n");
        }
        if (executableElement.getReturnType().getKind() != TypeKind.VOID) {
            stringBuilder.append("@return \n");
        }
        List<? extends ExpressionTree> list = (object3 = compilationInfo.getTrees().getTree(executableElement)) != null ? object3.getThrows() : null;
        int n = 0;
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            CharSequence charSequence;
            Element element;
            if (TypeKind.DECLARED == typeMirror.getKind() || TypeKind.ERROR == typeMirror.getKind()) {
                element = (TypeElement)((DeclaredType)typeMirror).asElement();
                charSequence = element.getQualifiedName();
                if (list != null) {
                    charSequence = Analyzer.resolveThrowsName(element, charSequence.toString(), list.get(n));
                }
            } else if (TypeKind.TYPEVAR == typeMirror.getKind()) {
                element = (TypeParameterElement)((TypeVariable)typeMirror).asElement();
                charSequence = element.getSimpleName();
            } else {
                throw new IllegalStateException("Illegal kind: " + (Object)((Object)typeMirror.getKind()));
            }
            stringBuilder.append("@throws ").append(charSequence).append(" \n");
            ++n;
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(compilationInfo, executableElement)) {
            stringBuilder.append("@deprecated\n");
        }
        stringBuilder.append("*/\n");
        return stringBuilder.toString();
    }

    public String generateComment(VariableElement variableElement, CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder("/**\n\n");
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(compilationInfo, variableElement)) {
            stringBuilder.append("@deprecated\n");
        }
        stringBuilder.append("*/\n");
        return stringBuilder.toString();
    }

    public String generateComment(Element element, CompilationInfo compilationInfo) {
        switch (element.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return this.generateComment((TypeElement)element, compilationInfo);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return this.generateComment((ExecutableElement)element, compilationInfo);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return this.generateComment((VariableElement)element, compilationInfo);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)element.getKind()) + ", " + element.getClass() + ": " + element.toString());
    }

    public String generateInheritComment() {
        return "/** {@inheritDoc} */";
    }

    public void updateSettings(FileObject fileObject) {
        DataObject dataObject = null;
        DataFolder dataFolder = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            dataFolder = dataObject.getFolder();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        if (dataObject == null || dataFolder == null) {
            return;
        }
        for (CreateFromTemplateAttributesProvider createFromTemplateAttributesProvider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
            Object v;
            Map map = createFromTemplateAttributesProvider.attributesFor(dataObject, dataFolder, "XXX");
            if (map == null || (v = map.get("user")) == null) continue;
            this.author = v.toString();
            break;
        }
    }
}

