/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class Settings {
    private static final Logger LOG = Logger.getLogger(Settings.class.getName());
    public static final String PROP_PDF_VIEWER = "PDFViewer";
    private static final Settings INSTANCE = new Settings();

    public static Settings getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    public File getPDFViewer() {
        String fileName = Settings.getPreferences().get(PROP_PDF_VIEWER, null);
        return fileName != null && fileName.length() != 0 ? new File(fileName) : null;
    }

    public void setPDFViewer(File viewer) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Settings[" + this + "].setPDFViewer: " + viewer);
        }
        Settings.getPreferences().put(PROP_PDF_VIEWER, viewer != null ? viewer.toString() : "");
    }
}

