/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.PhpPreferences;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.ftp.FtpConnectionProvider;
import org.netbeans.modules.php.project.connections.sftp.SftpConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.netbeans.modules.php.project.connections.ui.RemoteConnectionsPanel;
import org.openide.util.NbBundle;

public final class RemoteConnections {
    static final Logger LOGGER = Logger.getLogger(RemoteConnections.class.getName());
    private static final RemoteConnections INSTANCE = new RemoteConnections();
    private static final String PREFERENCES_PATH = "RemoteConnections";
    private static final RemoteConfiguration UNKNOWN_REMOTE_CONFIGURATION = new RemoteConfiguration.Empty("unknown-config", NbBundle.getMessage(RemoteConnections.class, (String)"LBL_UnknownRemoteConfiguration"));
    private final ConfigManager configManager;
    private final ConfigManager.ConfigProvider configProvider = new DefaultConfigProvider();
    RemoteConnectionsPanel panel = null;

    public static RemoteConnections get() {
        return INSTANCE;
    }

    private RemoteConnections() {
        this.configManager = new ConfigManager(this.configProvider);
    }

    private void initPanel() {
        if (this.panel != null) {
            return;
        }
        this.panel = new RemoteConnectionsPanel(this, this.configManager);
        this.panel.setConfigurations(this.getConfigurations());
    }

    private static Preferences getPreferences() {
        return PhpPreferences.getPreferences(true).node(PREFERENCES_PATH);
    }

    public boolean openManager() {
        return this.openManager(null);
    }

    public boolean openManager(RemoteConfiguration remoteConfiguration) {
        this.initPanel();
        assert (this.panel != null);
        List<RemoteConfiguration> remoteConfigurations = this.getRemoteConfigurations();
        boolean changed = this.panel.open(remoteConfiguration);
        if (changed) {
            this.saveRemoteConnections(remoteConfigurations);
        }
        return changed;
    }

    public void addChangeListener(ChangeListener listener) {
        this.configManager.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.configManager.removeChangeListener(listener);
    }

    List<RemoteConnectionProvider> getConnectionProviders() {
        return Arrays.asList(FtpConnectionProvider.get(), SftpConnectionProvider.get());
    }

    public List<String> getRemoteConnectionTypes() {
        ArrayList<String> names = new ArrayList<String>();
        for (RemoteConnectionProvider provider : this.getConnectionProviders()) {
            names.add(provider.getDisplayName());
        }
        return Collections.unmodifiableList(names);
    }

    public RemoteConfiguration getRemoteConfiguration(ConfigManager.Configuration cfg) {
        for (RemoteConnectionProvider provider : this.getConnectionProviders()) {
            RemoteConfiguration configuration = provider.getRemoteConfiguration(cfg);
            if (configuration == null) continue;
            return configuration;
        }
        return null;
    }

    public RemoteConfigurationPanel getConfigurationPanel(ConfigManager.Configuration cfg) {
        for (RemoteConnectionProvider provider : this.getConnectionProviders()) {
            RemoteConfigurationPanel configurationPanel = provider.getRemoteConfigurationPanel(cfg);
            if (configurationPanel == null) continue;
            return configurationPanel;
        }
        return null;
    }

    public String getConfigurationType(ConfigManager.Configuration cfg) {
        for (RemoteConnectionProvider provider : this.getConnectionProviders()) {
            RemoteConfigurationPanel remoteConfigurationPanel = provider.getRemoteConfigurationPanel(cfg);
            if (remoteConfigurationPanel == null) continue;
            return provider.getDisplayName();
        }
        return null;
    }

    public List<RemoteConfiguration> getRemoteConfigurations() {
        List<ConfigManager.Configuration> configs = this.getConfigurations();
        ArrayList<RemoteConfiguration> remoteConfigs = new ArrayList<RemoteConfiguration>(configs.size());
        for (ConfigManager.Configuration cfg : configs) {
            RemoteConfiguration configuration = this.getRemoteConfiguration(cfg);
            if (configuration == null) {
                configuration = UNKNOWN_REMOTE_CONFIGURATION;
            }
            remoteConfigs.add(configuration);
        }
        return Collections.unmodifiableList(remoteConfigs);
    }

    public RemoteConfiguration remoteConfigurationForName(String name) {
        assert (name != null);
        for (RemoteConfiguration remoteConfig : this.getRemoteConfigurations()) {
            if (!remoteConfig.getName().equals(name)) continue;
            return remoteConfig;
        }
        return null;
    }

    public RemoteConfiguration createRemoteConfiguration(String type, ConfigManager.Configuration configuration) {
        assert (type != null);
        for (RemoteConnectionProvider provider : this.getConnectionProviders()) {
            if (!type.equals(provider.getDisplayName())) continue;
            RemoteConfiguration remoteConfiguration = provider.createRemoteConfiguration(configuration);
            assert (remoteConfiguration != null) : "Remote configuration must be provided for " + type;
            return remoteConfiguration;
        }
        return null;
    }

    private List<ConfigManager.Configuration> getConfigurations() {
        Collection<String> cfgNames = this.configManager.configurationNames();
        ArrayList<ConfigManager.Configuration> configs = new ArrayList<ConfigManager.Configuration>(cfgNames.size() - 1);
        for (String name : cfgNames) {
            ConfigManager.Configuration cfg;
            if (name == null || (cfg = this.configManager.configurationFor(name)) == null) continue;
            configs.add(cfg);
        }
        Collections.sort(configs, ConfigManager.getConfigurationComparator());
        return configs;
    }

    private void saveRemoteConnections(List<RemoteConfiguration> originalRemoteConfigurations) {
        Preferences remoteConnections = RemoteConnections.getPreferences();
        for (Map.Entry<String, Map<String, String>> entry : this.configProvider.getConfigs().entrySet()) {
            RemoteConfiguration remoteConfiguration2;
            String config = entry.getKey();
            if (config == null) continue;
            Map<String, String> cfg = entry.getValue();
            if (cfg == null) {
                try {
                    remoteConnections.node(config).removeNode();
                    for (RemoteConfiguration remoteConfiguration2 : originalRemoteConfigurations) {
                        if (!remoteConfiguration2.getName().equals(config)) continue;
                        remoteConfiguration2.notifyDeleted();
                    }
                }
                catch (BackingStoreException bse) {
                    LOGGER.log(Level.INFO, "Error while removing unused remote connection: " + config, bse);
                }
                continue;
            }
            ConfigManager.Configuration configuration = this.configManager.configurationFor(config);
            assert (configuration != null);
            remoteConfiguration2 = this.getRemoteConfiguration(configuration);
            assert (remoteConfiguration2 != null);
            Preferences node = remoteConnections.node(config);
            for (Map.Entry<String, String> cfgEntry : cfg.entrySet()) {
                String value;
                String key = cfgEntry.getKey();
                if (remoteConfiguration2.saveProperty(key, value = cfgEntry.getValue())) {
                    node.remove(key);
                    continue;
                }
                node.put(key, value);
            }
        }
    }

    private class DefaultConfigProvider
    implements ConfigManager.ConfigProvider {
        final Map<String, Map<String, String>> configs = ConfigManager.createEmptyConfigs();

        public DefaultConfigProvider() {
            this.readConfigs();
        }

        @Override
        public String[] getConfigProperties() {
            HashSet<String> properties = new HashSet<String>();
            for (RemoteConnectionProvider provider : RemoteConnections.this.getConnectionProviders()) {
                properties.addAll(provider.getPropertyNames());
            }
            return properties.toArray(new String[properties.size()]);
        }

        @Override
        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }

        @Override
        public String getActiveConfig() {
            return null;
        }

        @Override
        public void setActiveConfig(String configName) {
        }

        private void readConfigs() {
            Preferences remoteConnections = RemoteConnections.getPreferences();
            try {
                for (String name : remoteConnections.childrenNames()) {
                    Preferences node = remoteConnections.node(name);
                    TreeMap<String, String> value = new TreeMap<String, String>();
                    for (String key : node.keys()) {
                        value.put(key, node.get(key, null));
                    }
                    this.configs.put(name, value);
                }
            }
            catch (BackingStoreException bse) {
                LOGGER.log(Level.INFO, "Error while reading existing remote connections", bse);
            }
        }
    }
}

