/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGLocatableElement;

public final class HighlightAction
extends AbstractComposerAction {
    private final SVGObject m_highlighted;

    public HighlightAction(ComposerActionFactory factory, SVGObject highlighted) {
        super(factory);
        assert (highlighted != null) : "Null object for highlight";
        this.m_highlighted = highlighted;
        this.getScreenManager().getAnimatorView().setToolTipText(this.getTooltipText());
        this.m_highlighted.repaint(5);
    }

    @Override
    public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
        SceneManager sceneMgr = this.m_factory.getSceneManager();
        assert (sceneMgr.containsAction(HighlightAction.class));
        if (!isOutsideEvent) {
            if (evt.getID() == 503) {
                MouseEvent me = (MouseEvent)evt;
                SVGObject[] objects = sceneMgr.getPerseusController().getObjectsAt(me.getX(), me.getY());
                if (objects == null || objects.length == 0 || objects[0] != this.m_highlighted) {
                    this.actionCompleted();
                }
            } else if (evt.getID() == 505) {
                this.actionCompleted();
            }
        }
        return false;
    }

    @Override
    public void paint(Graphics g, int x, int y, boolean isReadOnly) {
        if (!this.m_highlighted.isDeleted()) {
            if (!this.m_isCompleted && this.getScreenManager().getHighlightObject()) {
                this.m_highlighted.getOutline().highlight(g, x, y);
            }
        } else {
            this.actionCompleted();
        }
    }

    @Override
    public void actionCompleted() {
        super.actionCompleted();
        this.getScreenManager().getAnimatorView().setToolTipText("");
        this.m_highlighted.repaint(5);
    }

    private String getTooltipText() {
        String text = "";
        if (this.getScreenManager().getShowTooltip()) {
            SVGLocatableElement elem = this.m_highlighted.getSVGElement();
            String prefix = this.getPerseusController().getSVGDocument().toPrefix(elem.getNamespaceURI(), (Element)elem);
            if (prefix == null || prefix.length() == 0) {
                prefix = elem.getLocalName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html>&nbsp;");
            sb.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_Type", (Object)prefix));
            sb.append("<br>&nbsp;");
            String id = elem.getId();
            if (id != null) {
                sb.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_Id", (Object)id));
                sb.append("<br>");
                sb.append(this.getDataObject().getModel().describeElement(id));
            }
            sb.append("</html>");
            return sb.toString();
        }
        return text;
    }
}

